/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.util.LoaderUtil;

@Plugin(name="JacksonMixIn", category="Core", elementType="jacksonMixIn", printObject=true)
public class JacksonMixIn {
    public static final String PLUGIN_NAME = "JacksonMixIn";
    public static final String ELEMENT_TYPE = "jacksonMixIn";
    private final Class targetClass;
    private final Class mixInClass;

    protected JacksonMixIn(Class targetClass, Class mixInClass) {
        this.targetClass = targetClass;
        this.mixInClass = mixInClass;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public Class getMixInClass() {
        return this.mixInClass;
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<JacksonMixIn> {
        @PluginBuilderAttribute(value="targetClass")
        private String targetClassName;
        @PluginBuilderAttribute(value="mixInClass")
        private String mixInClassName;

        public JacksonMixIn build() {
            Class targetClass = this.loadClass(this.targetClassName, "targetClass");
            Class mixInClass = this.loadClass(this.mixInClassName, "mixInClass");
            return new JacksonMixIn(targetClass, mixInClass);
        }

        private Class loadClass(String className, String argName) {
            if (className == null) {
                throw new ConfigurationException(String.format("No %s provided for %s", argName, JacksonMixIn.PLUGIN_NAME));
            }
            try {
                return LoaderUtil.loadClass((String)className);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException(String.format("Cannot load %s: %s for %s", argName, className, JacksonMixIn.PLUGIN_NAME));
            }
        }

        public Builder withTargetClass(String targetClass) {
            this.targetClassName = targetClass;
            return this;
        }

        public Builder withMixInClass(String mixInClass) {
            this.mixInClassName = mixInClass;
            return this;
        }
    }
}

