/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import com.fasterxml.jackson.databind.ObjectWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.appenders.core.logging.InternalLogging;
import org.appenders.core.logging.Logger;
import org.appenders.log4j2.elasticsearch.ByteBufBoundedSizeLimitPolicy;
import org.appenders.log4j2.elasticsearch.ByteBufPooledObjectOps;
import org.appenders.log4j2.elasticsearch.GenericItemSourcePool;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.ItemSourceFactory;
import org.appenders.log4j2.elasticsearch.ItemSourcePool;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.PoolResourceException;
import org.appenders.log4j2.elasticsearch.ResizePolicy;
import org.appenders.log4j2.elasticsearch.UnlimitedResizePolicy;
import org.appenders.log4j2.elasticsearch.thirdparty.ReusableByteBufOutputStream;

@Plugin(name="PooledItemSourceFactory", category="Core", elementType="itemSourceFactory", printObject=true)
public class PooledItemSourceFactory
implements ItemSourceFactory {
    public static final String PLUGIN_NAME = "PooledItemSourceFactory";
    protected static final Logger LOGGER = InternalLogging.getLogger();
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    final ItemSourcePool bufferedItemSourcePool;

    protected PooledItemSourceFactory(ItemSourcePool bufferedItemSourcePool) {
        this.bufferedItemSourcePool = bufferedItemSourcePool;
    }

    @Override
    public final boolean isBuffered() {
        return true;
    }

    @Override
    public ItemSource create(Object source, ObjectWriter objectWriter) {
        ItemSource pooled;
        try {
            pooled = this.bufferedItemSourcePool.getPooled();
        }
        catch (PoolResourceException e) {
            throw new IllegalStateException(e);
        }
        try {
            ReusableByteBufOutputStream byteBufOutputStream = new ReusableByteBufOutputStream((ByteBuf)pooled.getSource());
            objectWriter.writeValue((OutputStream)byteBufOutputStream, source);
            return pooled;
        }
        catch (IOException e) {
            pooled.release();
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ItemSource createEmptySource() {
        try {
            return this.bufferedItemSourcePool.getPooled();
        }
        catch (PoolResourceException e) {
            throw new IllegalStateException(e);
        }
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public void start() {
        if (!this.bufferedItemSourcePool.isStarted()) {
            this.bufferedItemSourcePool.start();
        }
        this.state = LifeCycle.State.STARTED;
    }

    @Override
    public void stop() {
        if (!this.bufferedItemSourcePool.isStopped()) {
            this.bufferedItemSourcePool.stop();
        }
        this.state = LifeCycle.State.STOPPED;
    }

    @Override
    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    @Override
    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<PooledItemSourceFactory> {
        public static final long DEFAULT_RESIZE_TIMEOUT = 1000L;
        public static final long DEFAULT_MONITOR_TASK_INTERVAL = 30000L;
        @PluginBuilderAttribute
        protected String poolName;
        @PluginElement(value="resizePolicy")
        protected ResizePolicy resizePolicy;
        @PluginBuilderAttribute
        protected int itemSizeInBytes;
        @PluginBuilderAttribute
        protected int initialPoolSize;
        @PluginBuilderAttribute
        protected boolean monitored;
        @PluginBuilderAttribute
        protected long monitorTaskInterval = 30000L;
        @PluginBuilderAttribute
        protected long resizeTimeout = 1000L;
        @PluginBuilderAttribute
        protected int maxItemSizeInBytes = Integer.MAX_VALUE;

        public PooledItemSourceFactory build() {
            if (this.initialPoolSize <= 0) {
                throw new ConfigurationException("initialPoolSize must be higher than 0 for PooledItemSourceFactory");
            }
            if (this.itemSizeInBytes <= 0) {
                throw new ConfigurationException("itemSizeInBytes must be higher than 0 for PooledItemSourceFactory");
            }
            if (this.maxItemSizeInBytes <= 0) {
                throw new ConfigurationException("maxItemSizeInBytes must be higher than 0 for PooledItemSourceFactory");
            }
            if (this.maxItemSizeInBytes < this.itemSizeInBytes) {
                throw new ConfigurationException("maxItemSizeInBytes must be higher than or equal to itemSizeInBytes for PooledItemSourceFactory");
            }
            if (this.poolName == null) {
                this.poolName = ItemSourcePool.class.getSimpleName();
            }
            if (this.resizePolicy == null) {
                ResizePolicy resizePolicy = this.createResizePolicy();
                LOGGER.info("No configured {} found for pool {}. Defaulting to {}", "resizePolicy", this.poolName, resizePolicy.getClass().getSimpleName());
                this.resizePolicy = resizePolicy;
            }
            return new PooledItemSourceFactory(this.configuredItemSourcePool());
        }

        ResizePolicy createResizePolicy() {
            return UnlimitedResizePolicy.newBuilder().build();
        }

        ItemSourcePool configuredItemSourcePool() {
            UnpooledByteBufAllocator byteBufAllocator = new UnpooledByteBufAllocator(false, false, false);
            ByteBufPooledObjectOps pooledObjectOps = new ByteBufPooledObjectOps(byteBufAllocator, new ByteBufBoundedSizeLimitPolicy(this.itemSizeInBytes, this.maxItemSizeInBytes));
            return new GenericItemSourcePool<ByteBuf>(this.poolName, pooledObjectOps, this.resizePolicy, this.resizeTimeout, this.monitored, this.monitorTaskInterval, this.initialPoolSize);
        }

        public Builder withItemSizeInBytes(int itemSizeInBytes) {
            this.itemSizeInBytes = itemSizeInBytes;
            return this;
        }

        public Builder withMaxItemSizeInBytes(int maxItemSizeInBytes) {
            this.maxItemSizeInBytes = maxItemSizeInBytes;
            return this;
        }

        public Builder withInitialPoolSize(int initialPoolSize) {
            this.initialPoolSize = initialPoolSize;
            return this;
        }

        public Builder withPoolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public Builder withResizePolicy(ResizePolicy resizePolicy) {
            this.resizePolicy = resizePolicy;
            return this;
        }

        public Builder withMonitored(boolean monitored) {
            this.monitored = monitored;
            return this;
        }

        public Builder withMonitorTaskInterval(long monitorTaskInterval) {
            this.monitorTaskInterval = monitorTaskInterval;
            return this;
        }

        public Builder withResizeTimeout(long resizeTimeout) {
            this.resizeTimeout = resizeTimeout;
            return this;
        }
    }
}

