/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.function.Function;
import org.apache.logging.log4j.core.LogEvent;
import org.appenders.log4j2.elasticsearch.BatchDelivery;
import org.appenders.log4j2.elasticsearch.ItemAppender;
import org.appenders.log4j2.elasticsearch.LifeCycle;

public class StringAppender
implements ItemAppender<LogEvent> {
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    private final BatchDelivery batchDelivery;
    private final Function<LogEvent, String> serializer;

    public StringAppender(BatchDelivery batchDelivery, Function<LogEvent, String> serializer) {
        this.batchDelivery = batchDelivery;
        this.serializer = serializer;
    }

    @Override
    public void append(String formattedIndexName, LogEvent logEvent) {
        this.batchDelivery.add(formattedIndexName, this.serializer.apply(logEvent));
    }

    @Override
    public void start() {
        this.batchDelivery.start();
        this.state = LifeCycle.State.STARTED;
    }

    @Override
    public void stop() {
        if (!this.batchDelivery.isStopped()) {
            this.batchDelivery.stop();
        }
        this.state = LifeCycle.State.STOPPED;
    }

    @Override
    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    @Override
    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }
}

