/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.StampedLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.openhft.chronicle.map.ChronicleMap;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.failover.MapProxy;
import org.jetbrains.annotations.NotNull;

class ChronicleMapProxy
implements MapProxy<CharSequence, ItemSource> {
    private final ChronicleMap<CharSequence, ItemSource> chronicleMap;
    private final StampedLock stampedLock = new StampedLock();

    public ChronicleMapProxy(ChronicleMap<CharSequence, ItemSource> chronicleMap) {
        this.chronicleMap = chronicleMap;
    }

    @Override
    public ItemSource put(CharSequence key, ItemSource failedItem) {
        return this.executeExclusive(this::putInternal, key, failedItem);
    }

    @Override
    public ItemSource remove(Object key) {
        return this.executeExclusive(this::removeInternal, (CharSequence)key);
    }

    @Override
    public void putAll(@NotNull Map<? extends CharSequence, ? extends ItemSource> map) {
        this.chronicleMap.putAll(map);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.chronicleMap.containsKey(key);
    }

    @Override
    public ItemSource get(Object key) {
        return (ItemSource)this.chronicleMap.get(key);
    }

    @Override
    public void clear() {
        this.chronicleMap.clear();
    }

    @Override
    @NotNull
    public Set<CharSequence> keySet() {
        return this.chronicleMap.keySet();
    }

    @Override
    @NotNull
    public Collection<ItemSource> values() {
        return this.chronicleMap.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<CharSequence, ItemSource>> entrySet() {
        return this.chronicleMap.entrySet();
    }

    @Override
    public int size() {
        return this.chronicleMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.chronicleMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.chronicleMap.containsValue(value);
    }

    @Override
    public void close() {
        this.chronicleMap.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R> R executeExclusive(Function<T, R> op, T arg) {
        long stamp = this.stampedLock.writeLock();
        try {
            R r = op.apply(arg);
            return r;
        }
        finally {
            this.stampedLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, U, R> R executeExclusive(BiFunction<T, U, R> op, T arg1, U arg2) {
        long stamp = this.stampedLock.writeLock();
        try {
            R r = op.apply(arg1, arg2);
            return r;
        }
        finally {
            this.stampedLock.unlockWrite(stamp);
        }
    }

    private ItemSource putInternal(CharSequence key, ItemSource failedItem) {
        this.chronicleMap.put((Object)key, (Object)failedItem);
        return null;
    }

    private ItemSource removeInternal(CharSequence key) {
        return (ItemSource)this.chronicleMap.remove((Object)key);
    }
}

