/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.openhft.chronicle.hash.ChronicleHashCorruption;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.map.ChronicleMap;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.appenders.core.logging.InternalLogging;
import org.appenders.core.logging.Logger;
import org.appenders.log4j2.elasticsearch.DelayedShutdown;
import org.appenders.log4j2.elasticsearch.FailoverPolicy;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.failover.ChronicleMapProxy;
import org.appenders.log4j2.elasticsearch.failover.FailedItemMarshaller;
import org.appenders.log4j2.elasticsearch.failover.FailoverListener;
import org.appenders.log4j2.elasticsearch.failover.KeySequence;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfigRepository;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceSelector;
import org.appenders.log4j2.elasticsearch.failover.MapProxy;
import org.appenders.log4j2.elasticsearch.failover.RetryListener;
import org.appenders.log4j2.elasticsearch.failover.RetryProcessor;

@Plugin(name="ChronicleMapRetryFailoverPolicy", category="Core", elementType="failoverPolicy", printObject=true)
public class ChronicleMapRetryFailoverPolicy
implements FailoverPolicy<ItemSource>,
LifeCycle {
    public static final String PLUGIN_NAME = "ChronicleMapRetryFailoverPolicy";
    private static final Logger LOGGER = InternalLogging.getLogger();
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    private final MapProxy<CharSequence, ItemSource> failedItems;
    private final KeySequenceSelector keySequenceSelector;
    private final Supplier<KeySequence> keySequenceSupplier;
    private DelayedShutdown shutdown;
    Collection<ScheduledExecutorService> executors = new ConcurrentLinkedQueue<ScheduledExecutorService>();
    protected final AtomicInteger storeFailureCount = new AtomicInteger();
    protected final int batchSize;
    protected final long retryDelay;
    protected final boolean monitored;
    protected final long monitorTaskInterval;
    protected RetryListener[] retryListeners = new RetryListener[0];

    protected ChronicleMapRetryFailoverPolicy(Builder builder) {
        this.failedItems = builder.mapProxy;
        this.keySequenceSelector = builder.keySequenceSelector;
        this.keySequenceSupplier = this.keySequenceSelector.currentKeySequence();
        this.batchSize = builder.batchSize;
        this.retryDelay = builder.retryDelay;
        this.monitored = builder.monitored;
        this.monitorTaskInterval = builder.monitorTaskInterval;
    }

    @Override
    public <U extends FailoverListener> void addListener(U failoverListener) {
        if (failoverListener instanceof RetryListener) {
            ArrayList<RetryListener> listeners = new ArrayList<RetryListener>(Arrays.asList(this.retryListeners));
            listeners.add((RetryListener)failoverListener);
            this.retryListeners = listeners.toArray(new RetryListener[0]);
        }
    }

    @Override
    public void deliver(ItemSource failedItemSource) {
        CharSequence key = this.keySequenceSupplier.get().nextWriterKey();
        this.tryPut(key, failedItemSource);
    }

    boolean tryPut(CharSequence key, ItemSource failedItem) {
        if (failedItem == null) {
            return false;
        }
        try {
            this.failedItems.put(key, failedItem);
            return true;
        }
        catch (Exception e) {
            this.storeFailureCount.incrementAndGet();
            LOGGER.error("Unable to store {}. Cause: {}", failedItem.getClass().getSimpleName(), e.getMessage());
            return false;
        }
    }

    RetryProcessor createRetryProcessor() {
        return new RetryProcessor(this.batchSize, this.failedItems, this.retryListeners, this.keySequenceSelector);
    }

    MetricsPrinter createMetricPrinter() {
        return new MetricsPrinter();
    }

    ScheduledExecutorService createExecutor(String threadName) {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, threadName));
        this.executors.add(executor);
        return executor;
    }

    DelayedShutdown delayedShutdown() {
        return new DelayedShutdown(() -> this.executors.forEach(ExecutorService::shutdown)).onDecrement(remaining -> LOGGER.warn("{} ms before proceeding", remaining)).afterDelay(() -> {
            int totalKeys = this.failedItems.size();
            long enqueuedKeys = this.keySequenceSelector.currentKeySequence().get().readerKeysAvailable();
            LOGGER.info("sequenceId: {}, total: {}, enqueued: {}", this.keySequenceSelector.currentKeySequence().get().getConfig(true).getSeqId(), totalKeys, enqueuedKeys);
            this.keySequenceSelector.close();
            this.failedItems.close();
        });
    }

    private void schedule(ScheduledExecutorService executor, Runnable runnable, long interval) {
        executor.scheduleAtFixedRate(runnable, 0L, interval, TimeUnit.MILLISECONDS);
    }

    private void validateSetup() {
        if (this.retryListeners.length == 0) {
            throw new ConfigurationException(String.format("%s was not provided for %s", RetryListener.class.getSimpleName(), ChronicleMapRetryFailoverPolicy.class.getSimpleName()));
        }
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public void start() {
        if (!this.isStarted()) {
            this.validateSetup();
            this.shutdown = this.delayedShutdown();
            this.schedule(this.createExecutor("Retry-main"), this.createRetryProcessor(), this.retryDelay);
            if (this.monitored) {
                this.schedule(this.createExecutor("Retry-metrics"), this.createMetricPrinter(), this.monitorTaskInterval);
            }
            this.state = LifeCycle.State.STARTED;
        }
    }

    @Override
    public void stop() {
        if (!this.isStopped()) {
            int timeout = 0;
            boolean async = false;
            this.stop(timeout, async);
            this.state = LifeCycle.State.STOPPED;
        }
    }

    @Override
    public LifeCycle stop(long timeout, boolean async) {
        if (!this.isStopped()) {
            this.shutdown.delay(timeout).start(async);
            this.state = LifeCycle.State.STOPPED;
        }
        return this;
    }

    @Override
    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    @Override
    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }

    class MetricsPrinter
    implements Runnable {
        MetricsPrinter() {
        }

        @Override
        public void run() {
            int totalKeys = ChronicleMapRetryFailoverPolicy.this.failedItems.size();
            long enqueuedKeys = ChronicleMapRetryFailoverPolicy.this.keySequenceSelector.currentKeySequence().get().readerKeysAvailable();
            LOGGER.info("sequenceId: {}, total: {}, enqueued: {}", ChronicleMapRetryFailoverPolicy.this.keySequenceSelector.currentKeySequence().get().getConfig(true).getSeqId(), totalKeys, enqueuedKeys);
        }
    }

    static class HashCorruptionListener
    implements ChronicleHashCorruption.Listener {
        HashCorruptionListener() {
        }

        public void onCorruption(ChronicleHashCorruption corruption) {
            if (corruption.exception() != null) {
                LOGGER.error(corruption.message(), corruption.exception());
            } else {
                LOGGER.error(corruption.message(), new Object[0]);
            }
        }
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<ChronicleMapRetryFailoverPolicy> {
        public static final int DEFAULT_AVERAGE_VALUE_SIZE = 1024;
        public static final int DEFAULT_BATCH_SIZE = 1000;
        public static final int DEFAULT_RETRY_DELAY = 10000;
        @PluginBuilderAttribute(value="fileName")
        protected String fileName;
        @PluginBuilderAttribute(value="numberOfEntries")
        protected long numberOfEntries;
        @PluginBuilderAttribute(value="averageValueSize")
        protected int averageValueSize = 1024;
        @PluginBuilderAttribute(value="batchSize")
        protected int batchSize = 1000;
        @PluginBuilderAttribute(value="retryDelay")
        protected long retryDelay = 10000L;
        @PluginElement(value="keySequenceSelector")
        protected KeySequenceSelector keySequenceSelector;
        @PluginBuilderAttribute(value="monitored")
        protected boolean monitored;
        @PluginBuilderAttribute(value="monitorTaskInterval")
        protected long monitorTaskInterval = 10000L;
        private MapProxy<CharSequence, ItemSource> mapProxy;

        public final ChronicleMapRetryFailoverPolicy build() {
            if (this.keySequenceSelector == null) {
                throw new ConfigurationException(KeySequenceSelector.class.getSimpleName() + " was not provided for " + ChronicleMapRetryFailoverPolicy.class.getSimpleName());
            }
            if (this.fileName == null) {
                throw new ConfigurationException(String.format("fileName was not provided for %s", ChronicleMapRetryFailoverPolicy.class.getSimpleName()));
            }
            if (this.averageValueSize < 1024) {
                throw new ConfigurationException("averageValueSize must be higher than or equal 1024");
            }
            if (this.numberOfEntries <= 2L) {
                throw new ConfigurationException("numberOfEntries must be higher than 2");
            }
            if (this.batchSize <= 0) {
                throw new ConfigurationException("batchSize must be higher than 0");
            }
            try {
                this.mapProxy = new ChronicleMapProxy(this.createChronicleMap());
                this.keySequenceSelector = this.configuredKeySequenceSelector();
            }
            catch (Exception e) {
                throw new ConfigurationException("Could not initialize " + ChronicleMapRetryFailoverPolicy.class.getSimpleName(), (Throwable)e);
            }
            return new ChronicleMapRetryFailoverPolicy(this);
        }

        protected KeySequenceSelector configuredKeySequenceSelector() {
            KeySequenceConfigRepository repository = this.createKeySequenceConfigRepository(this.mapProxy);
            this.keySequenceSelector.withRepository(repository);
            KeySequence keySequence = this.keySequenceSelector.firstAvailable();
            if (keySequence == null) {
                throw new IllegalStateException("Failed to find a valid key sequence for " + ChronicleMapRetryFailoverPolicy.class);
            }
            return this.keySequenceSelector;
        }

        KeySequenceConfigRepository createKeySequenceConfigRepository(Map<CharSequence, ItemSource> map) {
            return new KeySequenceConfigRepository(map);
        }

        ChronicleMap<CharSequence, ItemSource> createChronicleMap() throws IOException {
            return this.defaultChronicleMapBuilder().averageKeySize(36.0).averageValueSize((double)this.averageValueSize).entries(this.numberOfEntries).putReturnsNull(true).removeReturnsNull(false).valueMarshaller((BytesReader)this.createItemMarshaller()).createOrRecoverPersistedTo(new File(this.fileName), false, (ChronicleHashCorruption.Listener)this.createCorruptionListener());
        }

        FailedItemMarshaller createItemMarshaller() {
            return new FailedItemMarshaller();
        }

        HashCorruptionListener createCorruptionListener() {
            return new HashCorruptionListener();
        }

        final ChronicleMapBuilder<CharSequence, ItemSource> defaultChronicleMapBuilder() {
            return ChronicleMap.of(CharSequence.class, ItemSource.class).name(this.getClass().getName());
        }

        public Builder withFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder withNumberOfEntries(long numberOfEntries) {
            this.numberOfEntries = numberOfEntries;
            return this;
        }

        public Builder withAverageValueSize(int averageValueSize) {
            this.averageValueSize = averageValueSize;
            return this;
        }

        public Builder withBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder withRetryDelay(long retryDelay) {
            this.retryDelay = retryDelay;
            return this;
        }

        public Builder withMonitored(boolean monitored) {
            this.monitored = monitored;
            return this;
        }

        public Builder withMonitorTaskInterval(long monitorTaskInterval) {
            this.monitorTaskInterval = monitorTaskInterval;
            return this;
        }

        public Builder withKeySequenceSelector(KeySequenceSelector keySequenceSelector) {
            this.keySequenceSelector = keySequenceSelector;
            return this;
        }
    }
}

