/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import io.netty.buffer.ByteBuf;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.ReadResolvable;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.appenders.core.logging.InternalLogging;
import org.appenders.core.logging.Logger;
import org.appenders.log4j2.elasticsearch.ByteBufItemSource;
import org.appenders.log4j2.elasticsearch.ExtendedObjectMapper;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.StringItemSource;
import org.appenders.log4j2.elasticsearch.failover.ByteBufItemSourceMixIn;
import org.appenders.log4j2.elasticsearch.failover.CompositeByteBufMixIn;
import org.appenders.log4j2.elasticsearch.failover.FailedItemInfo;
import org.appenders.log4j2.elasticsearch.failover.FailedItemInfoMixIn;
import org.appenders.log4j2.elasticsearch.failover.FailedItemSource;
import org.appenders.log4j2.elasticsearch.failover.FailedItemSourceDelegateMixIn;
import org.appenders.log4j2.elasticsearch.failover.ItemSourceMixIn;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfig;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfigKeys;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfigKeysMixIn;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfigMixIn;
import org.appenders.log4j2.elasticsearch.failover.StringItemSourceMixIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FailedItemMarshaller
implements BytesWriter<ItemSource>,
BytesReader<ItemSource>,
ReadResolvable<FailedItemMarshaller> {
    private static final Logger LOG = InternalLogging.getLogger();
    private ObjectMapper objectMapper;

    public FailedItemMarshaller() {
        this.readResolve();
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper.copy();
    }

    public void writeMarshallable(@NotNull WireOut wire) {
    }

    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
    }

    public FailedItemMarshaller readResolve() {
        if (this.objectMapper != null) {
            return this;
        }
        this.objectMapper = this.createConfiguredObjectMapper();
        return this;
    }

    ObjectMapper createConfiguredObjectMapper() {
        return new ExtendedObjectMapper(new JsonFactory()).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).configure(SerializationFeature.CLOSE_CLOSEABLE, false).addMixIn(FailedItemInfo.class, FailedItemInfoMixIn.class).addMixIn(ItemSource.class, ItemSourceMixIn.class).addMixIn(FailedItemSource.class, FailedItemSourceDelegateMixIn.class).addMixIn(ByteBufItemSource.class, ByteBufItemSourceMixIn.class).addMixIn(StringItemSource.class, StringItemSourceMixIn.class).addMixIn(ByteBuf.class, CompositeByteBufMixIn.class).addMixIn(KeySequenceConfigKeys.class, KeySequenceConfigKeysMixIn.class).addMixIn(KeySequenceConfig.class, KeySequenceConfigMixIn.class).setInjectableValues((InjectableValues)new InjectableValues.Std().addValue("releaseCallback", source -> ((ByteBuf)source.getSource()).release())).setVisibility((VisibilityChecker)VisibilityChecker.Std.defaultInstance().withFieldVisibility(JsonAutoDetect.Visibility.ANY));
    }

    public ItemSource read(Bytes in, @Nullable ItemSource using) {
        try {
            return (ItemSource)this.objectMapper.readValue(in.inputStream(), ItemSource.class);
        }
        catch (Exception e) {
            LOG.error("{} deserialization failed: {}. Returning null..", FailedItemSource.class.getSimpleName(), e.getMessage());
            return null;
        }
    }

    public void write(Bytes out, @NotNull ItemSource toWrite) {
        try {
            this.objectMapper.writeValue(out.outputStream(), (Object)toWrite);
        }
        catch (Exception e) {
            LOG.error("{} serialization failed: {}", FailedItemSource.class.getSimpleName(), e.getMessage());
        }
    }
}

