/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfig;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfigKeys;

public class KeySequenceConfigRepository {
    static final long DEFAULT_EXPIRE_IN_MILLIS = 10000L;
    static final CharSequence INDEX_KEY_NAME = new UUID(0L, 0L).toString();
    private final long consistencyCheckDelayNanos = TimeUnit.MILLISECONDS.toNanos(Long.parseLong(System.getProperty("appenders.failover.keysequence.consistencyCheckDelay", "200")));
    static final long ID = UUID.randomUUID().getMostSignificantBits();
    final long expireInMillis;
    final Map<CharSequence, ItemSource> map;

    public KeySequenceConfigRepository(Map<CharSequence, ItemSource> dataSource) {
        this(dataSource, Long.parseLong(System.getProperty("appenders.failover.keysequence.expireInMillis", String.valueOf(10000L))));
    }

    public KeySequenceConfigRepository(Map<CharSequence, ItemSource> dataSource, long expireInMillis) {
        this.map = dataSource;
        this.expireInMillis = expireInMillis;
        if (!this.map.containsKey(INDEX_KEY_NAME)) {
            this.map.put(INDEX_KEY_NAME, new KeySequenceConfigKeys(new ArrayList<CharSequence>()));
        }
    }

    public KeySequenceConfig get(CharSequence key) {
        return (KeySequenceConfig)this.map.get(key);
    }

    public boolean contains(CharSequence keySequenceConfigKey) {
        return this.map.containsKey(keySequenceConfigKey);
    }

    public void persist(KeySequenceConfig config) {
        if (!this.contains(config.getKey())) {
            this.registerKeySequenceConfig(config.getKey());
        }
        long now = System.currentTimeMillis();
        config.setExpireAt(now + this.expireInMillis);
        config.setOwnerId(ID);
        this.map.put(config.getKey(), config);
    }

    public void purge(KeySequenceConfig config) {
        this.map.remove(config.getKey());
        this.unregisterKeySequenceConfig(config.getKey());
    }

    public Collection<KeySequenceConfig> getAll() {
        ArrayList<KeySequenceConfig> configs = new ArrayList<KeySequenceConfig>();
        KeySequenceConfigKeys keySequenceConfigKeys = (KeySequenceConfigKeys)this.map.get(INDEX_KEY_NAME);
        for (CharSequence key : keySequenceConfigKeys.getKeys()) {
            configs.add((KeySequenceConfig)this.map.get(key));
        }
        return configs;
    }

    void registerKeySequenceConfig(CharSequence keySequenceConfigKey) {
        KeySequenceConfigKeys keySequenceConfigKeys = (KeySequenceConfigKeys)this.map.get(INDEX_KEY_NAME);
        List<CharSequence> keys = keySequenceConfigKeys.getKeys();
        keys.add(keySequenceConfigKey);
        this.map.put(INDEX_KEY_NAME, keySequenceConfigKeys);
    }

    void unregisterKeySequenceConfig(CharSequence keySequenceConfigKey) {
        KeySequenceConfigKeys keySequenceConfigKeys = (KeySequenceConfigKeys)this.map.get(INDEX_KEY_NAME);
        List<CharSequence> keys = keySequenceConfigKeys.getKeys();
        keys.remove(keySequenceConfigKey);
        this.map.put(INDEX_KEY_NAME, keySequenceConfigKeys);
    }

    boolean consistencyCheck(KeySequenceConfig config) {
        LockSupport.parkNanos(this.consistencyCheckDelayNanos);
        KeySequenceConfig actual = (KeySequenceConfig)this.map.get(config.getKey());
        return actual.getOwnerId() == ID;
    }
}

