/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.appenders.log4j2.elasticsearch.failover.KeySequence;

class KeySequenceIterator
implements Iterator<CharSequence> {
    private final KeySequence keySequence;
    private final AtomicLong remaining;

    public KeySequenceIterator(KeySequence keySequence, long maxKeys) {
        this.keySequence = keySequence;
        this.remaining = new AtomicLong(maxKeys);
    }

    @Override
    public boolean hasNext() {
        return this.remaining.get() > 0L && this.keySequence.readerKeysAvailable() > 0L;
    }

    @Override
    public CharSequence next() {
        this.remaining.decrementAndGet();
        return this.keySequence.nextReaderKey();
    }
}

