/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.appenders.core.logging.InternalLogging;
import org.appenders.core.logging.Logger;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.failover.FailedItemSource;
import org.appenders.log4j2.elasticsearch.failover.KeySequence;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceSelector;
import org.appenders.log4j2.elasticsearch.failover.RetryListener;

class RetryProcessor
implements Runnable {
    private static final Logger LOG = InternalLogging.getLogger();
    private final long backoffMillis;
    private final int maxRetryBatchSize;
    private final Map<CharSequence, ItemSource> items;
    private final RetryListener[] retryListeners;
    private final KeySequenceSelector keySequenceSelector;
    private final List<CharSequence> selectedKeysList;
    final AtomicLong orphanedKeyCount = new AtomicLong();
    final AtomicLong readFailureCount = new AtomicLong();

    public RetryProcessor(int maxRetryBatchSize, Map<CharSequence, ItemSource> failedItems, RetryListener[] retryListeners, KeySequenceSelector keySequenceSelector) {
        this.maxRetryBatchSize = maxRetryBatchSize;
        this.items = failedItems;
        this.retryListeners = retryListeners;
        this.keySequenceSelector = keySequenceSelector;
        this.selectedKeysList = new ArrayList<CharSequence>(maxRetryBatchSize);
        this.backoffMillis = TimeUnit.MILLISECONDS.toNanos(Long.parseLong(System.getProperty("appenders.retry.backoff.millis", "1000")));
    }

    @Override
    public final void run() {
        this.retry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retry() {
        KeySequence keySequence = this.keySequenceSelector.firstAvailable();
        if (keySequence == null) {
            return;
        }
        long keysAvailable = keySequence.readerKeysAvailable();
        if (keysAvailable == 0L) {
            return;
        }
        long remaining = Math.min((long)this.maxRetryBatchSize, keysAvailable);
        Iterator<CharSequence> keys = keySequence.nextReaderKeys(remaining);
        LOG.info("Retrying {} of {} items. Left behind: {}. Exceptions: {}", remaining, keysAvailable, this.orphanedKeyCount.get(), this.readFailureCount.get());
        while (keys.hasNext()) {
            this.selectedKeysList.add(keys.next());
        }
        if (this.backoffMillis > 0L) {
            LockSupport.parkNanos(this.backoffMillis);
        }
        Iterator<CharSequence> selectedKeys = this.selectedKeysList.iterator();
        try {
            while (selectedKeys.hasNext()) {
                CharSequence next = selectedKeys.next();
                this.retryInternal(next);
            }
        }
        catch (Exception e) {
            this.readFailureCount.incrementAndGet();
            LOG.error("Retry failed. Item may be lost. Cause: {}", e.getMessage());
        }
        finally {
            this.selectedKeysList.clear();
        }
        this.keySequenceSelector.firstAvailable();
    }

    private void retryInternal(CharSequence next) {
        ItemSource failedItem = this.items.remove(next);
        if (failedItem instanceof FailedItemSource) {
            this.notifyListeners((FailedItemSource)failedItem);
        } else if (failedItem == null) {
            this.orphanedKeyCount.incrementAndGet();
        } else {
            failedItem.release();
        }
    }

    private void notifyListeners(FailedItemSource failedItem) {
        for (int i = 0; i < this.retryListeners.length; ++i) {
            this.retryListeners[i].notify(failedItem);
        }
    }
}

