/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.appenders.core.logging.InternalLogging;
import org.appenders.core.logging.Logger;
import org.appenders.log4j2.elasticsearch.failover.KeySequence;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfig;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfigRepository;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceSelector;
import org.appenders.log4j2.elasticsearch.failover.UUIDSequence;

public class SingleKeySequenceSelector
implements KeySequenceSelector {
    private static final Logger LOG = InternalLogging.getLogger();
    private KeySequenceConfigRepository repository;
    final AtomicReference<KeySequence> current = new AtomicReference<Object>(null);
    final long sequenceId;

    public SingleKeySequenceSelector(long sequenceId) {
        this.sequenceId = sequenceId;
    }

    @Override
    public SingleKeySequenceSelector withRepository(KeySequenceConfigRepository keySequenceConfigRepository) {
        this.repository = keySequenceConfigRepository;
        return this;
    }

    @Override
    public void close() {
        this.repository.persist(this.current.get().getConfig(false));
    }

    @Override
    public Supplier<KeySequence> currentKeySequence() {
        return this.current::get;
    }

    @Override
    public final KeySequence firstAvailable() {
        if (this.repository == null) {
            throw new IllegalStateException(KeySequenceConfigRepository.class.getSimpleName() + " was not provided for " + SingleKeySequenceSelector.class.getSimpleName());
        }
        KeySequence keySequence = this.current.get();
        if (keySequence != null) {
            LOG.debug("Reusing current key sequence: {}", keySequence.getConfig(true));
            this.repository.persist(keySequence.getConfig(true));
            return keySequence;
        }
        KeySequenceConfig existing = this.findMatchingKeySequenceConfig();
        if (existing == null) {
            KeySequenceConfig newConfig = this.createKeySequenceConfig(this.sequenceId);
            LOG.info("No matching keys sequences found. Creating new {}", newConfig.getKey());
            this.setCurrent(newConfig);
            return this.current.get();
        }
        if (this.isExpired(existing) || this.isOwned(existing)) {
            LOG.info("Reusing expired key sequence: {}", existing.getKey());
            this.setCurrent(existing);
        }
        return this.current.get();
    }

    private boolean isOwned(KeySequenceConfig existing) {
        return KeySequenceConfigRepository.ID == existing.ownerId;
    }

    private KeySequenceConfig findMatchingKeySequenceConfig() {
        Collection<KeySequenceConfig> configs = this.repository.getAll();
        for (KeySequenceConfig config : configs) {
            if (config.getSeqId() != this.sequenceId) continue;
            return config;
        }
        return null;
    }

    boolean isExpired(KeySequenceConfig config) {
        return config.getExpireAt() <= System.currentTimeMillis();
    }

    private void setCurrent(KeySequenceConfig config) {
        this.repository.persist(config);
        if (this.repository.consistencyCheck(config)) {
            LOG.info("Current key sequence: {}", config.getKey());
            this.current.set(this.createKeySequence(config));
            return;
        }
        LOG.warn(String.format("Cannot reuse key sequence %s. Consistency check failed. It seems that other process is using this sequence right now.", config.getKey()), new Object[0]);
    }

    private KeySequence createKeySequence(KeySequenceConfig config) {
        return new UUIDSequence(config);
    }

    private KeySequenceConfig createKeySequenceConfig(long sequenceId) {
        return new KeySequenceConfig(sequenceId, 16L, 16L);
    }
}

