/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.appenders.core.logging.InternalLogging;
import org.appenders.core.logging.Logger;
import org.appenders.log4j2.elasticsearch.BatchEmitter;
import org.appenders.log4j2.elasticsearch.BatchEmitterFactory;
import org.appenders.log4j2.elasticsearch.ClientObjectFactory;
import org.appenders.log4j2.elasticsearch.FailoverPolicy;

public class BatchEmitterServiceProvider {
    private static final Logger LOG = InternalLogging.getLogger();
    private final Collection<Iterable<BatchEmitterFactory>> serviceLoaders;

    public BatchEmitterServiceProvider() {
        this(Arrays.asList(BatchEmitterServiceProvider.serviceLoader(Thread.currentThread().getContextClassLoader()), BatchEmitterServiceProvider.serviceLoader(BatchEmitterServiceProvider.class.getClassLoader())));
    }

    BatchEmitterServiceProvider(Collection<Iterable<BatchEmitterFactory>> serviceLoaders) {
        this.serviceLoaders = Collections.unmodifiableList(serviceLoaders.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public BatchEmitter createInstance(int batchSize, int deliveryInterval, ClientObjectFactory clientObjectFactory, FailoverPolicy failoverPolicy) {
        for (Iterable<BatchEmitterFactory> serviceLoader : this.serviceLoaders) {
            BatchEmitter batchEmitter = this.createInstance(batchSize, deliveryInterval, clientObjectFactory, failoverPolicy, serviceLoader);
            if (batchEmitter == null) continue;
            return batchEmitter;
        }
        throw new ConfigurationException(String.format("No compatible BatchEmitter implementations for %s found", clientObjectFactory.getClass().getName()));
    }

    private BatchEmitter createInstance(int batchSize, int deliveryInterval, ClientObjectFactory clientObjectFactory, FailoverPolicy failoverPolicy, Iterable<BatchEmitterFactory> serviceLoader) {
        for (BatchEmitterFactory factory : serviceLoader) {
            LOG.info("BatchEmitterFactory class found {}", factory.getClass().getName());
            if (!factory.accepts(clientObjectFactory.getClass())) continue;
            LOG.info("Using {} as BatchEmitterFactoryProvider", factory);
            return factory.createInstance(batchSize, deliveryInterval, clientObjectFactory, failoverPolicy);
        }
        return null;
    }

    private static Iterable<BatchEmitterFactory> serviceLoader(ClassLoader classLoader) {
        return ServiceLoader.load(BatchEmitterFactory.class, classLoader);
    }
}

