/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.BatchBuilder;
import org.appenders.log4j2.elasticsearch.BatchEmitter;
import org.appenders.log4j2.elasticsearch.BatchOperations;
import org.appenders.log4j2.elasticsearch.DelayedShutdown;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.QueueFactory;

public class BulkEmitter<BATCH_TYPE>
implements BatchEmitter {
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    private final AtomicInteger size = new AtomicInteger();
    private final Queue<Object> items = QueueFactory.getQueueFactoryInstance().tryCreateMpmcQueue(BulkEmitter.class.getSimpleName(), Integer.parseInt(System.getProperty("appenders." + BulkEmitter.class.getSimpleName() + ".initialSize", "65536")));
    private final AtomicBoolean notifying = new AtomicBoolean();
    private final AtomicReference<CountDownLatch> latchHolder = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
    private final int maxSize;
    private final int deliveryInterval;
    private final BatchOperations<BATCH_TYPE> batchOperations;
    private final Timer scheduler;
    private final DelayedShutdown delayedShutdown = new DelayedShutdown(this::doStop).onDecrement(remaining -> {
        InternalLogging.getLogger().info("Waiting for last items... {}s, {} items enqueued", new Object[]{remaining / 1000L, this.size.get()});
        this.notifyListener();
    });
    private Function<BATCH_TYPE, Boolean> listener;

    public BulkEmitter(int atSize, int intervalInMillis, BatchOperations<BATCH_TYPE> batchOperations) {
        this.maxSize = atSize;
        this.deliveryInterval = intervalInMillis;
        this.batchOperations = batchOperations;
        this.scheduler = new Timer("BatchNotifier");
    }

    public final void notifyListener() {
        if (this.notifying.compareAndSet(false, true)) {
            this.size.set(0);
            int actualSize = this.items.size();
            if (actualSize == 0) {
                this.notifying.set(false);
                return;
            }
            BatchBuilder<BATCH_TYPE> batch = this.batchOperations.createBatchBuilder();
            for (int ii = 0; ii < actualSize; ++ii) {
                batch.add(this.items.remove());
            }
            this.listener.apply(batch.build());
            this.latchHolder.getAndSet(new CountDownLatch(1)).countDown();
            this.notifying.set(false);
        } else {
            try {
                this.latchHolder.get().await(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                InternalLogging.getLogger().error("Interrupted while waiting for notification completion", new Object[0]);
                Thread.currentThread().interrupt();
            }
        }
    }

    public void add(Object batchItem) {
        this.items.add(batchItem);
        if (this.size.incrementAndGet() >= this.maxSize) {
            this.notifyListener();
        }
    }

    private TimerTask createNotificationTask() {
        return new TimerTask(){

            @Override
            public void run() {
                BulkEmitter.this.notifyListener();
            }
        };
    }

    public void addListener(Function<BATCH_TYPE, Boolean> onReadyListener) {
        this.listener = onReadyListener;
    }

    @Override
    public void start() {
        this.scheduler.scheduleAtFixedRate(this.createNotificationTask(), 1000L, (long)this.deliveryInterval);
        this.state = LifeCycle.State.STARTED;
    }

    @Override
    public void stop() {
        this.stop(0L, false);
    }

    @Override
    public LifeCycle stop(long timeout, boolean runInBackground) {
        this.delayedShutdown.delay(timeout).start(runInBackground);
        return this;
    }

    private void doStop() {
        if (!this.isStopped()) {
            InternalLogging.getLogger().debug("Stopping {}. Flushing last batch if possible.", new Object[]{this.getClass().getSimpleName()});
            this.notifyListener();
            this.scheduler.cancel();
            this.scheduler.purge();
            this.state = LifeCycle.State.STOPPED;
            InternalLogging.getLogger().debug("{} stopped", new Object[]{this.getClass().getSimpleName()});
        }
    }

    @Override
    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    @Override
    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }
}

