/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.appenders.log4j2.elasticsearch.OpSource;
import org.appenders.log4j2.elasticsearch.ResourceUtil;

public class ComponentTemplate
implements OpSource {
    public static final String TYPE_NAME = "ComponentTemplate";
    private final String name;
    private final String source;

    protected ComponentTemplate(String name, String source) {
        this.name = name;
        this.source = source;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return TYPE_NAME;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        protected String name;
        protected String path;
        protected String source;

        public ComponentTemplate build() {
            this.validate();
            return new ComponentTemplate(this.name, this.loadSource());
        }

        void validate() {
            if (this.name == null) {
                throw new IllegalArgumentException("No name provided for " + ComponentTemplate.class.getSimpleName());
            }
            if (this.path == null && this.source == null || this.path != null && this.source != null) {
                throw new IllegalArgumentException("Either path or source have to be provided for " + ComponentTemplate.class.getSimpleName());
            }
        }

        protected String loadSource() {
            if (this.source != null) {
                return this.source;
            }
            return ResourceUtil.loadResource(this.path);
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withSource(String source) {
            this.source = source;
            return this;
        }
    }
}

