/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.BatchDelivery;
import org.appenders.log4j2.elasticsearch.IndexNameFormatter;
import org.appenders.log4j2.elasticsearch.ItemAppender;
import org.appenders.log4j2.elasticsearch.ItemAppenderFactory;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.NoopIndexNameFormatter;

@Plugin(name="Elasticsearch", category="Core", elementType="appender", printObject=true)
public class ElasticsearchAppender
extends AbstractAppender {
    public static final String PLUGIN_NAME = "Elasticsearch";
    private final IndexNameFormatter indexNameFormatter;
    private final ItemAppender itemAppender;

    protected ElasticsearchAppender(String name, Filter filter, Layout layout, boolean ignoreExceptions, BatchDelivery batchDelivery, boolean messageOnly, IndexNameFormatter indexNameFormatter) {
        super(name, filter, layout, ignoreExceptions);
        this.indexNameFormatter = indexNameFormatter;
        this.itemAppender = this.createItemAppenderFactory().createInstance(messageOnly, (Layout<String>)layout, batchDelivery);
    }

    protected ItemAppenderFactory createItemAppenderFactory() {
        return new ItemAppenderFactory();
    }

    public void append(LogEvent event) {
        String formattedIndexName = this.indexNameFormatter.format(event);
        this.itemAppender.append(formattedIndexName, event);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public void start() {
        this.lifecycleStart();
        super.start();
    }

    public void stop() {
        LOGGER.debug("Stopping {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        super.stop();
        this.lifecycleStop();
        LOGGER.debug("{} stopped", (Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        LOGGER.debug("Stopping {} with timeout {} {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)timeout, (Object)timeUnit.toString());
        boolean stopped = super.stop(timeout, timeUnit);
        this.lifecycleStop();
        LOGGER.debug("{} stopped", (Object)((Object)((Object)this)).getClass().getSimpleName());
        return stopped;
    }

    private void lifecycleStart() {
        this.itemAppender.start();
        if (this.getLayout() instanceof LifeCycle) {
            ((LifeCycle)this.getLayout()).start();
        }
    }

    private void lifecycleStop() {
        if (!this.itemAppender.isStopped()) {
            this.itemAppender.stop();
        }
        if (this.getLayout() instanceof LifeCycle && !((LifeCycle)this.getLayout()).isStopped()) {
            ((LifeCycle)this.getLayout()).stop();
        }
        InternalLogging.setLogger(null);
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<ElasticsearchAppender> {
        public static final IndexNameFormatter DEFAULT_INDEX_NAME_FORMATTER = NoopIndexNameFormatter.newBuilder().withIndexName("log4j2").build();
        @PluginBuilderAttribute
        @Required(message="No name provided for Elasticsearch appender")
        private String name;
        @PluginElement(value="filter")
        private Filter filter;
        @PluginElement(value="layout")
        private Layout layout;
        @PluginBuilderAttribute
        private boolean ignoreExceptions;
        @PluginElement(value="batchDelivery")
        @Required(message="No BatchDelivery method provided for ElasticSearch appender")
        private BatchDelivery batchDelivery;
        @PluginBuilderAttribute
        private boolean messageOnly;
        @PluginElement(value="indexNameFormatter")
        private IndexNameFormatter indexNameFormatter = DEFAULT_INDEX_NAME_FORMATTER;

        public ElasticsearchAppender build() {
            if (this.name == null) {
                throw new ConfigurationException("No name provided for Elasticsearch appender");
            }
            if (this.batchDelivery == null) {
                throw new ConfigurationException("No batchDelivery [AsyncBatchDelivery] provided for Elasticsearch appender");
            }
            if (this.layout == null) {
                throw new ConfigurationException("No layout provided for Elasticsearch appender");
            }
            return new ElasticsearchAppender(this.name, this.filter, this.layout, this.ignoreExceptions, this.batchDelivery, this.messageOnly, this.indexNameFormatter);
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withFilter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public Builder withLayout(Layout layout) {
            this.layout = layout;
            return this;
        }

        public Builder withIgnoreExceptions(boolean ignoreExceptions) {
            this.ignoreExceptions = ignoreExceptions;
            return this;
        }

        public Builder withBatchDelivery(BatchDelivery batchDelivery) {
            this.batchDelivery = batchDelivery;
            return this;
        }

        public Builder withMessageOnly(boolean messageOnly) {
            this.messageOnly = messageOnly;
            return this;
        }

        public Builder withIndexNameFormatter(IndexNameFormatter indexNameFormatter) {
            this.indexNameFormatter = indexNameFormatter;
            return this;
        }
    }
}

