/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.ItemSourcePool;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.PoolResourceException;
import org.appenders.log4j2.elasticsearch.PooledObjectOps;
import org.appenders.log4j2.elasticsearch.QueueFactory;
import org.appenders.log4j2.elasticsearch.ReleaseCallback;
import org.appenders.log4j2.elasticsearch.ResizePolicy;

public class GenericItemSourcePool<T>
implements ItemSourcePool<T> {
    private static final int INITIAL_RESIZE_INTERNAL_STACK_DEPTH = 0;
    private static final int MAX_RESIZE_INTERNAL_STACK_DEPTH = 50;
    public static final String THREAD_NAME_FORMAT = "%s-%s";
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    private final Queue<ItemSource<T>> objectPool;
    private final String poolName;
    private final PooledObjectOps<T> pooledObjectOps;
    private final PooledItemSourceReleaseCallback releaseCallback = new PooledItemSourceReleaseCallback();
    private final ResizePolicy resizePolicy;
    private final long resizeTimeout;
    private final AtomicBoolean resizing = new AtomicBoolean();
    private final AtomicReference<CountDownLatch> countDownLatch = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
    private final int initialPoolSize;
    private final AtomicInteger totalPoolSize = new AtomicInteger();
    private final boolean monitored;
    private final long monitorTaskInterval;
    private final AtomicInteger thIndex = new AtomicInteger();
    ScheduledExecutorService executor;

    public GenericItemSourcePool(String poolName, PooledObjectOps<T> pooledObjectOps, ResizePolicy resizePolicy, long resizeTimeout, boolean monitored, long monitorTaskInterval, int initialPoolSize) {
        this.poolName = poolName;
        this.pooledObjectOps = pooledObjectOps;
        this.resizePolicy = resizePolicy;
        this.resizeTimeout = resizeTimeout;
        this.initialPoolSize = initialPoolSize;
        this.monitored = monitored;
        this.monitorTaskInterval = monitorTaskInterval;
        this.objectPool = QueueFactory.getQueueFactoryInstance().tryCreateMpmcQueue(this.getClass().getSimpleName(), initialPoolSize);
    }

    private void startRecyclerTask() {
        this.executor.scheduleAtFixedRate(new Recycler(this, this.resizePolicy), 1000L, 10000L, TimeUnit.MILLISECONDS);
    }

    void startMonitorTask(long monitorTaskInterval, Supplier<String> additionalMetricsSupplier) {
        this.executor.scheduleAtFixedRate(new MetricPrinter(this.getName() + "-MetricPrinter", new PoolMetrics(), additionalMetricsSupplier), Long.parseLong(System.getProperty("appenders." + GenericItemSourcePool.class.getSimpleName() + "metrics.start.delay", "1000")), monitorTaskInterval, TimeUnit.MILLISECONDS);
    }

    ScheduledExecutorService createExecutor() {
        return this.createExecutor(this.poolName);
    }

    ScheduledExecutorService createExecutor(String threadName) {
        return Executors.newScheduledThreadPool(2, r -> new Thread(r, String.format(THREAD_NAME_FORMAT, threadName, this.thIndex.incrementAndGet())));
    }

    @Override
    public final void incrementPoolSize(int delta) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < delta; ++i) {
            this.incrementPoolSize();
        }
        InternalLogging.getLogger().info("Pool [{}] {} pooled elements added. Total pooled elements: {}. Took: {}ms", new Object[]{this.getName(), delta, this.getTotalSize(), System.currentTimeMillis() - start});
    }

    @Override
    public final void incrementPoolSize() {
        this.objectPool.offer(this.pooledObjectOps.createItemSource(this.releaseCallback));
        this.totalPoolSize.getAndIncrement();
    }

    @Override
    public final ItemSource<T> getPooled() throws PoolResourceException {
        return this.removeInternal(0);
    }

    @Override
    public final boolean remove() {
        try {
            ItemSource<T> pooled = this.removeInternal(50);
            this.pooledObjectOps.purge(pooled);
            this.totalPoolSize.getAndDecrement();
        }
        catch (PoolResourceException e) {
            return false;
        }
        return true;
    }

    private ItemSource<T> removeInternal(int depth) throws PoolResourceException {
        try {
            if (this.objectPool.isEmpty()) {
                this.tryResize(depth);
            }
            return this.objectPool.remove();
        }
        catch (NoSuchElementException e) {
            this.tryResize(depth);
            return this.removeInternal(++depth);
        }
    }

    private boolean tryResize(int depth) throws PoolResourceException {
        if (depth > 50) {
            throw new PoolResourceException(String.format("ResizePolicy is ineffective. Pool %s has to be reconfigured to handle current load.", this.poolName));
        }
        if (this.resizing.compareAndSet(false, true)) {
            this.countDownLatch.set(new CountDownLatch(1));
            return this.resize(result -> {
                this.countDownLatch.get().countDown();
                this.resizing.set(false);
            });
        }
        try {
            this.countDownLatch.get().await(this.resizeTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e1) {
            throw new IllegalStateException("Thread interrupted while waiting for resizing to complete");
        }
        return false;
    }

    private boolean resize(Consumer<Boolean> callback) throws PoolResourceException {
        boolean resized = false;
        try {
            InternalLogging.getLogger().info("Pool [{}] attempting to resize using policy [{}]", new Object[]{this.getName(), this.resizePolicy.getClass().getName()});
            resized = this.resizePolicy.increase(this);
            if (!resized) {
                throw new PoolResourceException(String.format("Unable to resize. Creation of %s was unsuccessful", ItemSource.class.getSimpleName()));
            }
        }
        finally {
            callback.accept(resized);
        }
        return resized;
    }

    @Override
    public final String getName() {
        return this.poolName;
    }

    @Override
    public final int getInitialSize() {
        return this.initialPoolSize;
    }

    @Override
    public final int getTotalSize() {
        return this.totalPoolSize.get();
    }

    @Override
    public final int getAvailableSize() {
        return this.objectPool.size();
    }

    @Override
    public void shutdown() {
        InternalLogging.getLogger().debug("{} shutting down. Releasing buffers..", new Object[]{this.poolName});
        while (!this.objectPool.isEmpty()) {
            this.pooledObjectOps.purge(this.objectPool.remove());
        }
        InternalLogging.getLogger().debug("{} stopping internal threads..", new Object[]{this.poolName});
        this.executor.shutdown();
        InternalLogging.getLogger().debug("{} shutdown complete", new Object[]{this.poolName});
    }

    @Override
    public void start() {
        if (!this.isStarted()) {
            this.incrementPoolSize(this.initialPoolSize);
            this.executor = this.createExecutor(this.poolName);
            this.startRecyclerTask();
            if (this.monitored) {
                this.startMonitorTask(this.monitorTaskInterval, this.pooledObjectOps.createMetricsSupplier());
            }
            this.state = LifeCycle.State.STARTED;
        }
    }

    @Override
    public void stop() {
        if (!this.isStopped()) {
            this.state = LifeCycle.State.STOPPED;
            this.shutdown();
        }
    }

    @Override
    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    @Override
    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }

    class PoolMetrics {
        PoolMetrics() {
        }

        public String toString() {
            return this.formattedMetrics(null);
        }

        public String formattedMetrics(String additionalMetrics) {
            int capacity = additionalMetrics != null ? 384 : 96;
            StringBuilder sb = new StringBuilder(capacity).append('{').append(" poolName: ").append(GenericItemSourcePool.this.getName()).append(", initialPoolSize: ").append(GenericItemSourcePool.this.getInitialSize()).append(", totalPoolSize: ").append(GenericItemSourcePool.this.getTotalSize()).append(", availablePoolSize: ").append(GenericItemSourcePool.this.getAvailableSize());
            if (additionalMetrics != null) {
                sb.append(", additionalMetrics: ").append(additionalMetrics);
            }
            return sb.append('}').toString();
        }
    }

    static class MetricPrinter
    extends Thread {
        private final Supplier<String> additionalMetricsSupplier;
        private final Consumer<String> printer;

        MetricPrinter(String threadName, PoolMetrics poolMetrics, Supplier<String> additionalMetricsSupplier) {
            super(threadName);
            this.additionalMetricsSupplier = additionalMetricsSupplier;
            this.printer = additionalMetrics -> InternalLogging.getLogger().info(poolMetrics.formattedMetrics((String)additionalMetrics), new Object[0]);
        }

        @Override
        public void run() {
            this.printer.accept(this.additionalMetricsSupplier.get());
        }
    }

    static class Recycler
    extends Thread {
        private final ItemSourcePool pool;
        private final ResizePolicy resizePolicy;

        Recycler(ItemSourcePool pool, ResizePolicy resizePolicy) {
            super(pool.getName() + "-Recycler");
            this.pool = pool;
            this.resizePolicy = resizePolicy;
        }

        @Override
        public void run() {
            this.resizePolicy.decrease(this.pool);
        }
    }

    class PooledItemSourceReleaseCallback
    implements ReleaseCallback<T> {
        PooledItemSourceReleaseCallback() {
        }

        @Override
        public void completed(ItemSource<T> itemSource) {
            GenericItemSourcePool.this.pooledObjectOps.reset(itemSource);
            if (!GenericItemSourcePool.this.isStarted()) {
                GenericItemSourcePool.this.pooledObjectOps.purge(itemSource);
                return;
            }
            GenericItemSourcePool.this.objectPool.offer(itemSource);
        }
    }
}

