/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rolling.PatternProcessor;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;
import org.appenders.log4j2.elasticsearch.IndexNameFormatter;

@Plugin(name="RollingIndexName", category="Core", elementType="indexNameFormatter", printObject=true)
public class RollingIndexNameFormatter
implements IndexNameFormatter<LogEvent> {
    public static final String DEFAULT_SEPARATOR = "-";
    private final String indexName;
    private String currentName;
    private final String separator;
    private long nextRolloverTime;
    private final AtomicBoolean rollingOver = new AtomicBoolean();
    private final PatternProcessor patternProcessor;
    private final FastDateFormat fastDateFormat;
    private final int defaultBufferSize = 32;
    private long currentFileTime;

    protected RollingIndexNameFormatter(String indexName, String pattern, long initTimeInMillis, TimeZone timeZone) {
        this(indexName, pattern, initTimeInMillis, timeZone, DEFAULT_SEPARATOR);
    }

    protected RollingIndexNameFormatter(String indexName, String pattern, long initTimeInMillis, TimeZone timeZone, String separator) {
        this.indexName = indexName;
        this.fastDateFormat = FastDateFormat.getInstance((String)pattern, (TimeZone)timeZone);
        this.patternProcessor = this.createPatternProcessor(pattern);
        this.separator = separator;
        this.currentName = this.doFormat(indexName, initTimeInMillis);
        long previousTime = this.patternProcessor.getNextTime(initTimeInMillis, -1, false);
        this.patternProcessor.setPrevFileTime(previousTime);
        this.currentFileTime = this.nextRolloverTime = this.patternProcessor.getNextTime(initTimeInMillis, 0, false);
    }

    protected PatternProcessor createPatternProcessor(String pattern) {
        return new PatternProcessor("%d{" + pattern + "}");
    }

    long getNextRolloverTime() {
        return this.nextRolloverTime;
    }

    @Override
    public final String format(LogEvent event) {
        long eventTimeInMillis = event.getTimeMillis();
        if (eventTimeInMillis < this.currentFileTime) {
            return this.doFormat(this.indexName, eventTimeInMillis);
        }
        if (eventTimeInMillis >= this.nextRolloverTime && this.rollingOver.compareAndSet(false, true)) {
            this.rollover(this.indexName, eventTimeInMillis);
            this.rollingOver.set(false);
        }
        if (!this.rollingOver.get()) {
            return this.currentName;
        }
        return this.doFormat(this.indexName, eventTimeInMillis);
    }

    private void rollover(String indexName, long eventTimeInMillis) {
        this.nextRolloverTime = this.patternProcessor.getNextTime(eventTimeInMillis, 1, false);
        this.currentFileTime = this.patternProcessor.getNextTime(eventTimeInMillis, 0, false);
        this.currentName = this.doFormat(indexName, eventTimeInMillis);
    }

    private String doFormat(String indexName, long timeInMillis) {
        return ((StringBuilder)this.fastDateFormat.format(timeInMillis, (Appendable)this.buffer(indexName).append(this.separator))).toString();
    }

    private StringBuilder buffer(String indexName) {
        return new StringBuilder(32).append(indexName);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<RollingIndexNameFormatter> {
        public static final String DEFAULT_TIME_ZONE = TimeZone.getDefault().getID();
        @PluginBuilderAttribute
        @Required(message="No indexName provided for RollingIndexName")
        private String indexName;
        @PluginBuilderAttribute
        @Required(message="No pattern provided for RollingIndexName")
        private String pattern;
        @PluginBuilderAttribute
        private String timeZone = DEFAULT_TIME_ZONE;
        @PluginBuilderAttribute
        private String separator = "-";

        public RollingIndexNameFormatter build() {
            if (this.indexName == null) {
                throw new ConfigurationException("No indexName provided for RollingIndexName");
            }
            if (this.pattern == null) {
                throw new ConfigurationException("No pattern provided for RollingIndexName");
            }
            return new RollingIndexNameFormatter(this.indexName, this.pattern, this.getInitTimeInMillis(), TimeZone.getTimeZone(this.timeZone), this.separator);
        }

        public Builder withIndexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder withPattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder withTimeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public Builder withSeparator(String separator) {
            this.separator = separator;
            return this;
        }

        long getInitTimeInMillis() {
            return System.currentTimeMillis();
        }
    }
}

