/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonAppend;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import org.appenders.log4j2.elasticsearch.ValueResolver;
import org.appenders.log4j2.elasticsearch.VirtualProperty;
import org.appenders.log4j2.elasticsearch.VirtualPropertyFilter;

public class VirtualPropertiesWriter
extends VirtualBeanPropertyWriter {
    protected final VirtualProperty[] virtualProperties;
    protected final ValueResolver valueResolver;
    protected final VirtualPropertyFilter[] filters;

    VirtualPropertiesWriter() {
        throw new UnsupportedOperationException(String.format("Invalid use of %s. Use virtualProperties based constructors", VirtualPropertiesWriter.class.getSimpleName()));
    }

    public VirtualPropertiesWriter(VirtualProperty[] virtualProperties, ValueResolver valueResolver) {
        this(virtualProperties, valueResolver, new VirtualPropertyFilter[0]);
    }

    public VirtualPropertiesWriter(VirtualProperty[] virtualProperties, ValueResolver valueResolver, VirtualPropertyFilter[] filters) {
        this.virtualProperties = virtualProperties;
        this.valueResolver = valueResolver;
        this.filters = filters;
    }

    @Deprecated
    public VirtualPropertiesWriter(BeanPropertyDefinition propDef, Annotations annotations, JavaType type, VirtualProperty[] virtualProperties, ValueResolver valueResolver) {
        this(propDef, annotations, type, virtualProperties, valueResolver, new VirtualPropertyFilter[0]);
    }

    VirtualPropertiesWriter(BeanPropertyDefinition propDef, Annotations annotations, JavaType type, VirtualProperty[] virtualProperties, ValueResolver valueResolver, VirtualPropertyFilter[] filters) {
        super(propDef, annotations, type);
        this.virtualProperties = virtualProperties;
        this.valueResolver = valueResolver;
        this.filters = filters;
    }

    protected Object value(Object bean, JsonGenerator gen, SerializerProvider prov) {
        throw new UnsupportedOperationException("Should not be used with this implementation. Use serializeAsField() to write value directly.");
    }

    public void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        for (int i = 0; i < this.virtualProperties.length; ++i) {
            VirtualProperty property = this.virtualProperties[i];
            String resolved = this.valueResolver.resolve(property);
            if (this.isExcluded(property, resolved)) continue;
            gen.writeFieldName(property.getName());
            gen.writeString(resolved);
        }
    }

    private boolean isExcluded(VirtualProperty property, String resolved) {
        for (int i = 0; i < this.filters.length; ++i) {
            if (this.filters[i].isIncluded(property.getName(), resolved)) continue;
            return true;
        }
        return false;
    }

    public VirtualPropertiesWriter withConfig(MapperConfig<?> config, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new VirtualPropertiesWriter(propDef, (Annotations)new AnnotationCollector.OneAnnotation(declaringClass.getRawType(), declaringClass.getAnnotations().get(JsonAppend.class)), type, this.virtualProperties, this.valueResolver, this.filters);
    }

    public void fixAccess(SerializationConfig config) {
    }
}

