/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;

@Plugin(name="VirtualProperty", category="Core", printObject=true)
public class VirtualProperty {
    public static final String PLUGIN_NAME = "VirtualProperty";
    private final String name;
    private String value;
    private final boolean dynamic;

    public VirtualProperty(String name, String value, boolean isDynamic) {
        this.name = name;
        this.value = value;
        this.dynamic = isDynamic;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String resolved) {
        this.value = resolved;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public String toString() {
        return String.format("%s=%s", this.name, this.value);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<VirtualProperty> {
        @PluginBuilderAttribute
        private String name;
        @PluginBuilderAttribute
        private String value;
        @PluginBuilderAttribute
        private boolean dynamic;

        public VirtualProperty build() {
            if (this.name == null) {
                throw new ConfigurationException("No name provided for VirtualProperty");
            }
            if (this.value == null) {
                throw new ConfigurationException("No value provided for VirtualProperty");
            }
            return new VirtualProperty(this.name, this.value, this.dynamic);
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withDynamic(boolean isDynamic) {
            this.dynamic = isDynamic;
            return this;
        }
    }
}

