/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.backoff;

import java.util.concurrent.atomic.AtomicInteger;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.backoff.BackoffPolicy;

public class BatchLimitBackoffPolicy<T>
implements BackoffPolicy<T> {
    private final AtomicInteger batchesInFlight = new AtomicInteger();
    private final int maxBatchesInFlight;

    public BatchLimitBackoffPolicy(int maxBatchesInFlight) {
        this.maxBatchesInFlight = maxBatchesInFlight;
    }

    @Override
    public boolean shouldApply(T request) {
        InternalLogging.getLogger().debug("batchesInFlight: {}, maxBatchesInFlight: {}", new Object[]{this.batchesInFlight.get(), this.maxBatchesInFlight});
        return this.batchesInFlight.get() >= this.maxBatchesInFlight;
    }

    @Override
    public void register(T request) {
        this.batchesInFlight.incrementAndGet();
    }

    @Override
    public void deregister(T request) {
        this.batchesInFlight.decrementAndGet();
    }
}

