/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import org.appenders.log4j2.elasticsearch.ItemSource;

public class KeySequenceConfig
implements ItemSource<KeySequenceConfig>,
Serializable {
    protected final int initialHashTotal;
    protected final int hashConstant;
    protected final long seqId;
    protected final CharSequence key;
    protected long ownerId;
    protected long readerIndex;
    protected long writerIndex;
    protected long expireAt;

    public KeySequenceConfig(long seqId, long readerIndex, long writerIndex) {
        this.hashConstant = 17;
        this.initialHashTotal = 37 * this.hashConstant + (int)(seqId ^ seqId >> 32);
        this.seqId = seqId;
        this.readerIndex = readerIndex;
        this.writerIndex = writerIndex;
        this.key = new UUID(seqId, 0L).toString();
    }

    public CharSequence getKey() {
        return this.key;
    }

    public long getSeqId() {
        return this.seqId;
    }

    public long getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(long ownerId) {
        this.ownerId = ownerId;
    }

    public long getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(long expireAt) {
        this.expireAt = expireAt;
    }

    public long nextReaderIndex() {
        return this.readerIndex;
    }

    public void setReaderIndex(long readerIndex) {
        this.readerIndex = readerIndex;
    }

    public long nextWriterIndex() {
        return this.writerIndex;
    }

    public void setWriterIndex(long writerIndex) {
        this.writerIndex = writerIndex;
    }

    @Override
    public KeySequenceConfig getSource() {
        return this;
    }

    public String toString() {
        return new StringBuilder(128).append("{\"cls\": \"").append(KeySequenceConfig.class.getSimpleName()).append("\",").append("\"seqId\":").append(this.seqId).append(",").append("\"rIdx\":").append(this.readerIndex).append(",").append("\"wIdx\":").append(this.writerIndex).append("}").toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeySequenceConfig)) {
            return false;
        }
        KeySequenceConfig that = (KeySequenceConfig)obj;
        if (this.seqId != that.seqId) {
            return false;
        }
        if (this.ownerId != that.ownerId) {
            return false;
        }
        if (this.expireAt != that.expireAt) {
            return false;
        }
        if (this.readerIndex != that.readerIndex) {
            return false;
        }
        return this.writerIndex == that.writerIndex;
    }

    public int hashCode() {
        Objects.hash(this.seqId, this.expireAt, this.ownerId, this.readerIndex, this.writerIndex);
        int total = this.initialHashTotal;
        total = total * this.hashConstant + Long.hashCode(this.expireAt);
        total = total * this.hashConstant + Long.hashCode(this.ownerId);
        total = total * this.hashConstant + Long.hashCode(this.readerIndex);
        return total * this.hashConstant + Long.hashCode(this.writerIndex);
    }
}

