/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.failover;

import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.appenders.log4j2.elasticsearch.failover.KeySequence;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceConfig;
import org.appenders.log4j2.elasticsearch.failover.KeySequenceIterator;

public class UUIDSequence
implements KeySequence {
    public static final int RESERVED_KEYS = 16;
    private final long seqId;
    private final AtomicLong readerIndex;
    private final AtomicLong writerIndex;
    private final KeySequenceConfig config;
    private final int hashCode;

    public UUIDSequence(KeySequenceConfig keySequenceConfig) {
        if (keySequenceConfig.nextReaderIndex() < 16L) {
            throw new IllegalArgumentException("readerIndex cannot be lower than 16");
        }
        if (keySequenceConfig.nextWriterIndex() < 16L) {
            throw new IllegalArgumentException("writerIndex cannot be lower than 16");
        }
        this.config = keySequenceConfig;
        this.seqId = keySequenceConfig.getSeqId();
        this.readerIndex = new AtomicLong(keySequenceConfig.nextReaderIndex());
        this.writerIndex = new AtomicLong(keySequenceConfig.nextWriterIndex());
        this.hashCode = 1147 + Long.hashCode(this.seqId);
    }

    @Override
    public CharSequence nextReaderKey() {
        long current = this.readerIndex.get();
        if (this.readerKeysAvailable() > 0L && this.readerIndex.compareAndSet(current, current + 1L)) {
            return new UUID(this.seqId, current + 1L).toString();
        }
        return null;
    }

    @Override
    public CharSequence nextWriterKey() {
        return new UUID(this.seqId, this.writerIndex.incrementAndGet()).toString();
    }

    @Override
    public long readerKeysAvailable() {
        return this.writerIndex.get() - this.readerIndex.get();
    }

    @Override
    public KeySequenceConfig getConfig(boolean sharedInstance) {
        if (!sharedInstance) {
            return new KeySequenceConfig(this.seqId, this.readerIndex.get(), this.writerIndex.get());
        }
        this.config.setWriterIndex(this.writerIndex.get());
        this.config.setReaderIndex(this.readerIndex.get());
        return this.config;
    }

    @Override
    public Iterator<CharSequence> nextReaderKeys(long maxKeys) {
        return new KeySequenceIterator(this, maxKeys);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UUIDSequence)) {
            return false;
        }
        UUIDSequence that = (UUIDSequence)obj;
        return this.seqId == that.seqId;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

