/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.thirdparty;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.io.DataOutput;
import java.io.OutputStream;

public class ReusableByteBufOutputStream
extends OutputStream
implements DataOutput {
    private final ByteBuf buffer;

    public ReusableByteBufOutputStream(ByteBuf buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        this.buffer = buffer;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (len == 0) {
            return;
        }
        this.buffer.writeBytes(b, off, len);
    }

    @Override
    public void write(byte[] b) {
        this.buffer.writeBytes(b);
    }

    @Override
    public void write(int b) {
        this.buffer.writeByte(b);
    }

    @Override
    public void writeBoolean(boolean v) {
        this.buffer.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) {
        this.buffer.writeByte(v);
    }

    @Override
    public void writeBytes(String s) {
        this.buffer.writeCharSequence((CharSequence)s, CharsetUtil.US_ASCII);
    }

    @Override
    public void writeChar(int v) {
        this.buffer.writeChar(v);
    }

    @Override
    public void writeChars(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.buffer.writeChar((int)s.charAt(i));
        }
    }

    @Override
    public void writeDouble(double v) {
        this.buffer.writeDouble(v);
    }

    @Override
    public void writeFloat(float v) {
        this.buffer.writeFloat(v);
    }

    @Override
    public void writeInt(int v) {
        this.buffer.writeInt(v);
    }

    @Override
    public void writeLong(long v) {
        this.buffer.writeLong(v);
    }

    @Override
    public void writeShort(int v) {
        this.buffer.writeShort((int)((short)v));
    }

    @Override
    public void writeUTF(String s) {
        throw new UnsupportedOperationException("writeUTF(String) not supported. buffer-based API");
    }

    public ByteBuf buffer() {
        return this.buffer;
    }
}

