/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.BatchDelivery;
import org.appenders.log4j2.elasticsearch.BatchEmitter;
import org.appenders.log4j2.elasticsearch.BatchOperations;
import org.appenders.log4j2.elasticsearch.ClientObjectFactory;
import org.appenders.log4j2.elasticsearch.FailoverPolicy;
import org.appenders.log4j2.elasticsearch.IndexTemplate;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.NoopFailoverPolicy;
import org.appenders.log4j2.elasticsearch.OpSource;
import org.appenders.log4j2.elasticsearch.failover.FailoverListener;
import org.appenders.log4j2.elasticsearch.spi.BatchEmitterServiceProvider;

public class AsyncBatchDelivery
implements BatchDelivery<String> {
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    protected final BatchOperations batchOperations;
    protected final BatchEmitter batchEmitter;
    protected final ClientObjectFactory<Object, Object> objectFactory;
    protected final FailoverPolicy failoverPolicy;
    protected final List<OpSource> setupOpSources = new ArrayList<OpSource>();
    protected final long shutdownDelayMillis;

    protected AsyncBatchDelivery(int batchSize, int deliveryInterval, ClientObjectFactory objectFactory, FailoverPolicy failoverPolicy, long shutdownDelayMillis, OpSource[] setupOpSources) {
        this.batchOperations = objectFactory.createBatchOperations();
        this.batchEmitter = this.createBatchEmitterServiceProvider().createInstance(batchSize, deliveryInterval, objectFactory, failoverPolicy);
        this.objectFactory = objectFactory;
        this.failoverPolicy = failoverPolicy;
        this.shutdownDelayMillis = shutdownDelayMillis;
        this.setupOpSources.addAll(Arrays.asList(setupOpSources));
    }

    protected AsyncBatchDelivery(Builder builder) {
        this(builder.batchSize, builder.deliveryInterval, builder.clientObjectFactory, builder.failoverPolicy, builder.shutdownDelayMillis, builder.setupOpSources);
    }

    @Override
    public void add(String indexName, String log) {
        this.batchEmitter.add(this.batchOperations.createBatchItem(indexName, log));
    }

    @Override
    public void add(String indexName, ItemSource source) {
        this.batchEmitter.add(this.batchOperations.createBatchItem(indexName, source));
    }

    protected BatchEmitterServiceProvider createBatchEmitterServiceProvider() {
        return new BatchEmitterServiceProvider();
    }

    protected FailoverListener failoverListener() {
        return event -> {
            this.add(event.getInfo().getTargetName(), (ItemSource)event);
            return true;
        };
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public void start() {
        if (!this.objectFactory.isStarted()) {
            this.objectFactory.start();
        }
        for (OpSource setupOpSource : this.setupOpSources) {
            this.objectFactory.addOperation(this.objectFactory.setupOperationFactory().create(setupOpSource));
        }
        this.batchEmitter.start();
        if (!LifeCycle.of(this.failoverPolicy).isStarted()) {
            this.failoverPolicy.addListener(this.failoverListener());
            LifeCycle.of(this.failoverPolicy).start();
        }
        this.state = LifeCycle.State.STARTED;
    }

    @Override
    public void stop() {
        InternalLogging.getLogger().debug("Stopping {}", new Object[]{this.getClass().getSimpleName()});
        if (!LifeCycle.of(this.failoverPolicy).isStopped()) {
            LifeCycle.of(this.failoverPolicy).stop(this.shutdownDelayMillis, true);
        }
        if (!this.batchEmitter.isStopped()) {
            this.batchEmitter.stop(this.shutdownDelayMillis, false);
        }
        if (!this.objectFactory.isStopped()) {
            this.objectFactory.stop();
        }
        this.state = LifeCycle.State.STOPPED;
        InternalLogging.getLogger().debug("{} stopped", new Object[]{this.getClass().getSimpleName()});
    }

    @Override
    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    @Override
    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }

    public static class Builder {
        public static final int DEFAULT_BATCH_SIZE = 1000;
        public static final int DEFAULT_DELIVERY_INTERVAL = 1000;
        public static final FailoverPolicy DEFAULT_FAILOVER_POLICY = new NoopFailoverPolicy();
        public static final long DEFAULT_SHUTDOWN_DELAY = 5000L;
        public static final OpSource[] DEFAULT_OP_SOURCES = new OpSource[0];
        protected ClientObjectFactory clientObjectFactory;
        protected int deliveryInterval = 1000;
        protected int batchSize = 1000;
        protected FailoverPolicy failoverPolicy = DEFAULT_FAILOVER_POLICY;
        protected Long shutdownDelayMillis = 5000L;
        protected OpSource[] setupOpSources = DEFAULT_OP_SOURCES;

        public AsyncBatchDelivery build() {
            if (this.clientObjectFactory == null) {
                throw new IllegalArgumentException("No Elasticsearch client factory [HCHttp|JestHttp|ElasticsearchBulkProcessor] provided for " + AsyncBatchDelivery.class.getSimpleName());
            }
            if (this.batchSize <= 0) {
                throw new IllegalArgumentException("No batchSize provided for " + AsyncBatchDelivery.class.getSimpleName());
            }
            if (this.deliveryInterval <= 0) {
                throw new IllegalArgumentException("No deliveryInterval provided for " + AsyncBatchDelivery.class.getSimpleName());
            }
            return new AsyncBatchDelivery(this);
        }

        public Builder withClientObjectFactory(ClientObjectFactory clientObjectFactory) {
            this.clientObjectFactory = clientObjectFactory;
            return this;
        }

        public Builder withDeliveryInterval(int deliveryInterval) {
            this.deliveryInterval = deliveryInterval;
            return this;
        }

        public Builder withBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder withFailoverPolicy(FailoverPolicy failoverPolicy) {
            this.failoverPolicy = failoverPolicy;
            return this;
        }

        @Deprecated
        public Builder withIndexTemplate(IndexTemplate indexTemplate) {
            this.setupOpSources = this.addSetupOpSource(indexTemplate);
            return this;
        }

        public Builder withSetupOpSources(OpSource ... setupOpSources) {
            this.setupOpSources = this.addSetupOpSource(setupOpSources);
            return this;
        }

        public Builder withShutdownDelayMillis(long shutdownDelayMillis) {
            this.shutdownDelayMillis = shutdownDelayMillis;
            return this;
        }

        private OpSource[] addSetupOpSource(OpSource ... indexTemplates) {
            ArrayList<OpSource> current = new ArrayList<OpSource>(Arrays.asList(this.setupOpSources));
            current.addAll(Arrays.stream(indexTemplates).filter(Objects::nonNull).collect(Collectors.toList()));
            return current.toArray(new OpSource[0]);
        }
    }
}

