/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.appenders.log4j2.elasticsearch.AsyncBatchDelivery;
import org.appenders.log4j2.elasticsearch.ClientObjectFactory;
import org.appenders.log4j2.elasticsearch.FailoverPolicy;
import org.appenders.log4j2.elasticsearch.OpSource;

@Plugin(name="AsyncBatchDelivery", category="Core", elementType="batchDelivery", printObject=true)
public class AsyncBatchDeliveryPlugin
extends AsyncBatchDelivery {
    public static final String PLUGIN_NAME = "AsyncBatchDelivery";

    protected AsyncBatchDeliveryPlugin(AsyncBatchDelivery.Builder builder) {
        super(builder);
    }

    @PluginFactory
    public static AsyncBatchDeliveryPlugin createAsyncBatchDelivery(@PluginElement(value="objectFactory") ClientObjectFactory clientObjectFactory, @PluginAttribute(value="batchSize") int batchSize, @PluginAttribute(value="deliveryInterval") int deliveryInterval, @PluginElement(value="failoverPolicy") FailoverPolicy failoverPolicy, @PluginAttribute(value="shutdownDelayMillis") long shutdownDelayMillis, @PluginElement(value="setupOperation") OpSource[] setupOpSources) {
        if (clientObjectFactory == null) {
            throw new ConfigurationException("No Elasticsearch client factory [HCHttp|JestHttp|ElasticsearchBulkProcessor] provided for AsyncBatchDelivery");
        }
        AsyncBatchDelivery.Builder builder = new AsyncBatchDelivery.Builder().withClientObjectFactory(clientObjectFactory).withDeliveryInterval(deliveryInterval <= 0 ? 1000 : deliveryInterval).withBatchSize(batchSize <= 0 ? 1000 : batchSize).withFailoverPolicy(failoverPolicy == null ? AsyncBatchDelivery.Builder.DEFAULT_FAILOVER_POLICY : failoverPolicy).withSetupOpSources(setupOpSources.length == 0 ? AsyncBatchDelivery.Builder.DEFAULT_OP_SOURCES : setupOpSources).withShutdownDelayMillis(shutdownDelayMillis < 0L ? 5000L : shutdownDelayMillis);
        return new AsyncBatchDeliveryPlugin(builder);
    }
}

