/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.Queue;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.BatchBuilder;
import org.appenders.log4j2.elasticsearch.BatchEmitter;
import org.appenders.log4j2.elasticsearch.BatchOperations;
import org.appenders.log4j2.elasticsearch.DelayedShutdown;
import org.appenders.log4j2.elasticsearch.LifeCycle;
import org.appenders.log4j2.elasticsearch.QueueFactory;

public class BulkEmitter<BATCH_TYPE>
implements BatchEmitter {
    private final AtomicInteger size = new AtomicInteger();
    private final Queue<Object> items;
    private final int maxSize;
    private final AtomicBoolean notifying = new AtomicBoolean();
    private final ScheduledExecutorService executor;
    private final int deliveryInterval;
    private final BatchOperations<BATCH_TYPE> batchOperations;
    private Function<BATCH_TYPE, Boolean> listener;
    private final AtomicReference<CountDownLatch> latchHolder = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
    private volatile LifeCycle.State state = LifeCycle.State.STOPPED;
    private final int shutdownDecrementMillis = Integer.parseInt(System.getProperty("appenders." + BulkEmitter.class.getSimpleName() + ".shutdownDecrementMillis", "1000"));
    final DelayedShutdown delayedShutdown = new DelayedShutdown(this::doStop).decrementInMillis(this.shutdownDecrementMillis).onDecrement(remaining -> {
        InternalLogging.getLogger().info("Waiting for last items... {}s, {} items enqueued", new Object[]{remaining / 1000L, this.size.get()});
        this.notifyListener();
    });

    public BulkEmitter(int atSize, int intervalInMillis, BatchOperations<BATCH_TYPE> batchOperations) {
        this(atSize, intervalInMillis, batchOperations, QueueFactory.getQueueFactoryInstance().tryCreateMpmcQueue(BulkEmitter.class.getSimpleName(), Integer.parseInt(System.getProperty("appenders." + BulkEmitter.class.getSimpleName() + ".initialSize", "65536"))));
    }

    public BulkEmitter(int atSize, int intervalInMillis, BatchOperations<BATCH_TYPE> batchOperations, Queue<Object> queue) {
        this.maxSize = atSize;
        this.deliveryInterval = intervalInMillis;
        this.batchOperations = batchOperations;
        this.executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "BatchNotifier"));
        this.items = queue;
    }

    public final void notifyListener() {
        if (this.notifying.compareAndSet(false, true)) {
            this.size.set(0);
            int actualSize = this.items.size();
            if (actualSize == 0) {
                this.notifying.set(false);
                return;
            }
            BatchBuilder<BATCH_TYPE> batch = this.batchOperations.createBatchBuilder();
            for (int ii = 0; ii < actualSize; ++ii) {
                batch.add(this.items.remove());
            }
            this.listener.apply(batch.build());
            this.latchHolder.getAndSet(new CountDownLatch(1)).countDown();
            this.notifying.set(false);
        } else {
            try {
                this.latchHolder.get().await(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                InternalLogging.getLogger().error("Interrupted while waiting for notification completion", new Object[0]);
                Thread.currentThread().interrupt();
            }
        }
    }

    public void add(Object batchItem) {
        this.items.add(batchItem);
        if (this.size.incrementAndGet() >= this.maxSize) {
            this.notifyListener();
        }
    }

    private TimerTask createNotificationTask() {
        return new TimerTask(){

            @Override
            public void run() {
                BulkEmitter.this.notifyListener();
            }
        };
    }

    public void addListener(Function<BATCH_TYPE, Boolean> onReadyListener) {
        this.listener = onReadyListener;
    }

    void shutdownExecutor(long timeout) {
        this.executor.shutdown();
        try {
            boolean terminated = this.executor.awaitTermination(timeout, TimeUnit.MILLISECONDS);
            InternalLogging.getLogger().info("{}: Executor was {}shutdown gracefully", new Object[]{this.getClass().getSimpleName(), terminated ? "" : "not "});
        }
        catch (InterruptedException e) {
            InternalLogging.getLogger().error("{}: Executor shutdown interrupted", new Object[]{this.getClass().getSimpleName()});
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void start() {
        long startDelayInMillis = Long.parseLong(System.getProperty("appenders." + BulkEmitter.class.getSimpleName() + ".startDelay", Integer.toString(this.deliveryInterval)));
        this.executor.scheduleAtFixedRate(this.createNotificationTask(), startDelayInMillis, this.deliveryInterval, TimeUnit.MILLISECONDS);
        this.state = LifeCycle.State.STARTED;
    }

    @Override
    public void stop() {
        this.stop(0L, false);
    }

    @Override
    public LifeCycle stop(long timeout, boolean runInBackground) {
        this.delayedShutdown.delay(timeout).start(runInBackground);
        return this;
    }

    private void doStop() {
        if (!this.isStopped()) {
            InternalLogging.getLogger().debug("Stopping {}. Flushing last batch if possible.", new Object[]{this.getClass().getSimpleName()});
            this.notifyListener();
            this.shutdownExecutor(1000L);
            this.state = LifeCycle.State.STOPPED;
            InternalLogging.getLogger().debug("{} stopped", new Object[]{this.getClass().getSimpleName()});
        }
    }

    @Override
    public boolean isStarted() {
        return this.state == LifeCycle.State.STARTED;
    }

    @Override
    public boolean isStopped() {
        return this.state == LifeCycle.State.STOPPED;
    }
}

