/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import io.netty.buffer.ByteBuf;
import org.appenders.log4j2.elasticsearch.SizeLimitPolicy;

class ByteBufBoundedSizeLimitPolicy
implements SizeLimitPolicy<ByteBuf> {
    private final int minSize;
    private final int maxSize;

    public ByteBufBoundedSizeLimitPolicy(int minSize, int maxSize) {
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    @Override
    public void limit(ByteBuf buf) {
        int capacity = buf.capacity();
        if (capacity > this.maxSize) {
            buf.capacity(this.maxSize);
            return;
        }
        if (capacity < this.minSize) {
            buf.capacity(this.minSize);
        }
    }
}

