/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.function.Supplier;
import org.appenders.log4j2.elasticsearch.ByteBufBoundedSizeLimitPolicy;
import org.appenders.log4j2.elasticsearch.ByteBufItemSource;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.PooledObjectOps;
import org.appenders.log4j2.elasticsearch.ReleaseCallback;
import org.appenders.log4j2.elasticsearch.SizeLimitPolicy;

class ByteBufPooledObjectOps
implements PooledObjectOps<ByteBuf> {
    private static final int NAX_NUM_COMPONENTS = Integer.parseInt(System.getProperty("appenders.io.netty.buffer.CompositeByteBuf.maxNumComponents", "2"));
    private final UnpooledByteBufAllocator byteBufAllocator;
    private final SizeLimitPolicy<ByteBuf> sizeLimitPolicy;

    @Deprecated
    ByteBufPooledObjectOps(UnpooledByteBufAllocator byteBufAllocator, int initialSize) {
        this(byteBufAllocator, new ByteBufBoundedSizeLimitPolicy(initialSize, Integer.MAX_VALUE));
    }

    ByteBufPooledObjectOps(UnpooledByteBufAllocator byteBufAllocator, SizeLimitPolicy<ByteBuf> sizeLimitPolicy) {
        this.byteBufAllocator = byteBufAllocator;
        this.sizeLimitPolicy = sizeLimitPolicy;
    }

    public ByteBufItemSource createItemSource(ReleaseCallback<ByteBuf> releaseCallback) {
        CompositeByteBuf buffer = new CompositeByteBuf((ByteBufAllocator)this.byteBufAllocator, false, NAX_NUM_COMPONENTS);
        this.sizeLimitPolicy.limit((ByteBuf)buffer);
        return new ByteBufItemSource((ByteBuf)buffer, releaseCallback);
    }

    @Override
    public void reset(ItemSource<ByteBuf> pooled) {
        ByteBuf buffer = pooled.getSource();
        buffer.clear();
        this.sizeLimitPolicy.limit(buffer);
    }

    @Override
    public boolean purge(ItemSource<ByteBuf> pooled) {
        return pooled.getSource().release();
    }

    @Override
    public Supplier<String> createMetricsSupplier() {
        return () -> this.byteBufAllocator.metric().toString();
    }
}

