/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginValue;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.appenders.log4j2.elasticsearch.ILMPolicy;
import org.appenders.log4j2.elasticsearch.ResourceUtil;

@Plugin(name="ILMPolicy", category="Core", elementType="setupOperation", printObject=true)
public class ILMPolicyPlugin
extends ILMPolicy {
    public static final String PLUGIN_NAME = "ILMPolicy";

    protected ILMPolicyPlugin(String policyName, String rolloverAlias, String source) {
        super(policyName, rolloverAlias, source);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<ILMPolicyPlugin> {
        @PluginAttribute(value="name")
        @Required
        private String name;
        @PluginAttribute(value="rolloverAlias")
        @Required
        private String rolloverAlias;
        @PluginAttribute(value="path")
        private String path;
        @PluginValue(value="sourceString")
        private String source;

        public ILMPolicyPlugin build() {
            if (this.name == null) {
                throw new ConfigurationException("No name provided for ILMPolicy");
            }
            if (this.rolloverAlias == null) {
                throw new ConfigurationException("No rolloverAlias provided for ILMPolicy");
            }
            if (this.path == null && this.source == null || this.path != null && this.source != null) {
                throw new ConfigurationException("Either path or source have to be provided for ILMPolicy");
            }
            return new ILMPolicyPlugin(this.name, this.rolloverAlias, this.loadSource());
        }

        private String loadSource() {
            if (this.source != null) {
                return this.source;
            }
            return ResourceUtil.loadResource(this.path);
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withRolloverAlias(String rolloverAlias) {
            this.rolloverAlias = rolloverAlias;
            return this;
        }

        public Builder withSource(String source) {
            this.source = source;
            return this;
        }
    }
}

