/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.appenders.log4j2.elasticsearch.ItemSourcePool;
import org.appenders.log4j2.elasticsearch.ResizePolicy;

public class LimitedResizePolicy
implements ResizePolicy {
    public static final String PLUGIN_NAME = "LimitedResizePolicy";
    protected final double resizeFactor;
    protected final int maxSize;

    protected LimitedResizePolicy(double resizeFactor, int maxSize) {
        this.resizeFactor = resizeFactor;
        this.maxSize = maxSize;
    }

    @Override
    public boolean increase(ItemSourcePool itemSourcePool) {
        int initialSize = itemSourcePool.getInitialSize();
        int additionalPoolSize = (int)((double)initialSize * this.resizeFactor);
        if (additionalPoolSize == 0) {
            throw new IllegalArgumentException(String.format("Applying %s with resizeFactor %s will not resize given pool [%s] with initialPoolSize %s", ResizePolicy.class.getSimpleName(), this.resizeFactor, itemSourcePool.getName(), initialSize));
        }
        int totalSize = itemSourcePool.getTotalSize();
        if (additionalPoolSize + totalSize > this.maxSize) {
            additionalPoolSize = this.maxSize - totalSize;
        }
        if (additionalPoolSize > 0) {
            itemSourcePool.incrementPoolSize(additionalPoolSize);
            return true;
        }
        return false;
    }

    @Override
    public boolean decrease(ItemSourcePool itemSourcePool) {
        int availableSize = itemSourcePool.getAvailableSize();
        int decreaseSize = (int)((double)itemSourcePool.getTotalSize() * this.resizeFactor);
        if (decreaseSize > availableSize) {
            return false;
        }
        if (availableSize - decreaseSize < itemSourcePool.getInitialSize()) {
            decreaseSize = availableSize - itemSourcePool.getInitialSize();
        }
        for (int ii = 0; ii < decreaseSize; ++ii) {
            itemSourcePool.remove();
        }
        return true;
    }

    @Override
    public boolean canResize(ItemSourcePool itemSourcePool) {
        return itemSourcePool.getTotalSize() < this.maxSize;
    }

    public static class Builder {
        public static final double DEFAULT_RESIZE_FACTOR = 0.5;
        protected double resizeFactor = 0.5;
        protected int maxSize;

        public LimitedResizePolicy build() {
            if (this.resizeFactor <= 0.0) {
                throw new IllegalArgumentException("resizeFactor must be higher than 0");
            }
            if (this.resizeFactor > 1.0) {
                throw new IllegalArgumentException("resizeFactor must be lower or equal 1");
            }
            if (this.maxSize <= 0) {
                throw new IllegalArgumentException("maxSize must be higher or equal 1");
            }
            return new LimitedResizePolicy(this.resizeFactor, this.maxSize);
        }

        public Builder withResizeFactor(double resizeFactor) {
            this.resizeFactor = resizeFactor;
            return this;
        }

        public Builder withMaxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }
    }
}

