/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.appenders.log4j2.elasticsearch.LimitedResizePolicy;

@Plugin(name="LimitedResizePolicy", category="Core", elementType="resizePolicy", printObject=true)
public class LimitedResizePolicyPlugin
extends LimitedResizePolicy {
    public static final String PLUGIN_NAME = "LimitedResizePolicy";

    protected LimitedResizePolicyPlugin(double resizeFactor, int maxSize) {
        super(resizeFactor, maxSize);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends LimitedResizePolicy.Builder
    implements org.apache.logging.log4j.core.util.Builder<LimitedResizePolicy> {
        public static final double DEFAULT_RESIZE_FACTOR = 0.5;
        @PluginBuilderAttribute
        protected double resizeFactor = 0.5;
        @PluginBuilderAttribute
        @Required(message="No maxSize provided for LimitedResizePolicy")
        protected int maxSize;

        @Override
        public LimitedResizePolicyPlugin build() {
            if (this.resizeFactor <= 0.0) {
                throw new ConfigurationException("resizeFactor must be higher than 0");
            }
            if (this.resizeFactor > 1.0) {
                throw new ConfigurationException("resizeFactor must be lower or equal 1");
            }
            if (this.maxSize <= 0) {
                throw new ConfigurationException("maxSize must be higher or equal 1");
            }
            return new LimitedResizePolicyPlugin(this.resizeFactor, this.maxSize);
        }

        @Override
        public Builder withResizeFactor(double resizeFactor) {
            this.resizeFactor = resizeFactor;
            return this;
        }

        @Override
        public Builder withMaxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }
    }
}

