/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.appenders.core.logging.InternalLogging;
import org.jctools.queues.MpmcUnboundedXaddArrayQueue;
import org.jctools.queues.MpscUnboundedArrayQueue;
import org.jctools.queues.SpscUnboundedArrayQueue;

public class QueueFactory {
    private static final QueueFactory INSTANCE = new QueueFactory();

    public static QueueFactory getQueueFactoryInstance() {
        return INSTANCE;
    }

    public final <T> Queue<T> tryCreateMpscQueue(String name, int initialSize) {
        return this.tryCreate(name, "org.jctools.queues.MpscUnboundedArrayQueue", initialSize);
    }

    public final <T> Queue<T> tryCreateSpscQueue(String name, int initialSize) {
        return this.tryCreate(name, "org.jctools.queues.SpscUnboundedArrayQueue", initialSize);
    }

    public final <T> Queue<T> tryCreateMpmcQueue(String name, int initialSize) {
        return this.tryCreate(name, "org.jctools.queues.MpmcUnboundedXaddArrayQueue", initialSize);
    }

    final <T> Queue<T> tryCreate(String name, String queueClassName, int initialSize) {
        if (this.isEnabled(name, "jctools") && this.hasClass(name, queueClassName)) {
            InternalLogging.getLogger().debug("{}: Using {}", new Object[]{name, queueClassName});
            switch (queueClassName) {
                case "org.jctools.queues.MpmcUnboundedXaddArrayQueue": {
                    return new MpmcUnboundedXaddArrayQueue(initialSize);
                }
                case "org.jctools.queues.SpscUnboundedArrayQueue": {
                    return new SpscUnboundedArrayQueue(initialSize);
                }
                case "org.jctools.queues.MpscUnboundedArrayQueue": {
                    return new MpscUnboundedArrayQueue(initialSize);
                }
            }
            throw new UnsupportedOperationException(queueClassName + " is not supported");
        }
        ConcurrentLinkedQueue fallback = new ConcurrentLinkedQueue();
        InternalLogging.getLogger().debug("{}: Falling back to {}", new Object[]{name, fallback.getClass().getName()});
        return fallback;
    }

    private boolean isEnabled(String name, String featureName) {
        String propertyName = String.format("appenders.%s.%s.enabled", name, featureName);
        return Boolean.parseBoolean(System.getProperty(propertyName, "true"));
    }

    boolean hasClass(String name, String className) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            InternalLogging.getLogger().debug("{}: {} not available", new Object[]{name, className});
            return false;
        }
    }

    public <T> Collection<T> toIterable(Collection<T> items) {
        if (items instanceof ConcurrentLinkedQueue) {
            return items;
        }
        if (items instanceof AbstractQueue) {
            AbstractQueue arrayQueue = (AbstractQueue)items;
            int size = items.size();
            ArrayList result = new ArrayList(size);
            while (size-- > 0) {
                result.add(arrayQueue.poll());
            }
            return result;
        }
        return items;
    }
}

