/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.stream.Stream;

public class ResourceUtil {
    public static final String CLASSPATH_PREFIX = "classpath:";

    private ResourceUtil() {
    }

    public static String loadResource(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri cannot be null");
        }
        if (uri.contains(CLASSPATH_PREFIX)) {
            return ResourceUtil.loadClasspathResource(uri);
        }
        return ResourceUtil.loadFileSystemResource(uri);
    }

    private static String loadClasspathResource(String path) {
        try {
            String line;
            String resourcePath = path.replace(CLASSPATH_PREFIX, "");
            InputStream resource = ResourceUtil.loadClasspathResource(resourcePath, ResourceUtil.getClassLoaders());
            if (resource == null) {
                throw new IllegalArgumentException("Requested classpath resource was null: " + path);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception while loading classpath resource: " + e.getMessage(), e);
        }
    }

    private static InputStream loadClasspathResource(String resourcePath, ClassLoader ... classLoaders) {
        for (ClassLoader classLoader : classLoaders) {
            InputStream resource = classLoader.getResourceAsStream(resourcePath);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    private static ClassLoader[] getClassLoaders() {
        return (ClassLoader[])Stream.of(ClassLoader.getSystemClassLoader(), Thread.currentThread().getContextClassLoader()).filter(Objects::nonNull).toArray(ClassLoader[]::new);
    }

    private static String loadFileSystemResource(String path) {
        try {
            return new String(Files.readAllBytes(Paths.get(path, new String[0])));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Exception while loading file resource: " + e.getMessage(), e);
        }
    }
}

