/*
 * Decompiled with CFR 0.152.
 */
package org.appenders.log4j2.elasticsearch.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.appenders.core.logging.InternalLogging;
import org.appenders.log4j2.elasticsearch.BatchEmitter;
import org.appenders.log4j2.elasticsearch.BatchEmitterFactory;
import org.appenders.log4j2.elasticsearch.ClientObjectFactory;
import org.appenders.log4j2.elasticsearch.FailoverPolicy;

public class BatchEmitterServiceProvider {
    private static final Comparator<BatchEmitterFactory> LOADING_ORDER = new NaturalLoadingOrder();
    private final Collection<Iterable<BatchEmitterFactory>> serviceLoaders;

    public BatchEmitterServiceProvider() {
        this(Arrays.asList(BatchEmitterServiceProvider.serviceLoader(Thread.currentThread().getContextClassLoader()), BatchEmitterServiceProvider.serviceLoader(BatchEmitterServiceProvider.class.getClassLoader())));
    }

    BatchEmitterServiceProvider(Collection<Iterable<BatchEmitterFactory>> serviceLoaders) {
        this.serviceLoaders = Collections.unmodifiableList(serviceLoaders.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public BatchEmitter createInstance(int batchSize, int deliveryInterval, ClientObjectFactory clientObjectFactory, FailoverPolicy failoverPolicy) {
        TreeSet<BatchEmitterFactory> batchEmitterFactories = new TreeSet<BatchEmitterFactory>(LOADING_ORDER);
        for (Iterable<BatchEmitterFactory> serviceLoader : this.serviceLoaders) {
            batchEmitterFactories.addAll(this.getCompatibleFactories(clientObjectFactory, serviceLoader));
        }
        for (BatchEmitterFactory factory : batchEmitterFactories) {
            Object batchEmitter = factory.createInstance(batchSize, deliveryInterval, clientObjectFactory, failoverPolicy);
            if (batchEmitter == null) continue;
            InternalLogging.getLogger().info("Using {} as {}", new Object[]{factory.getClass().getName(), this.getClass().getSimpleName()});
            return batchEmitter;
        }
        throw new ConfigurationException(String.format("No compatible BatchEmitter implementations for %s found", clientObjectFactory.getClass().getName()));
    }

    private List<BatchEmitterFactory> getCompatibleFactories(ClientObjectFactory clientObjectFactory, Iterable<BatchEmitterFactory> serviceLoader) {
        ArrayList<BatchEmitterFactory> factories = new ArrayList<BatchEmitterFactory>();
        for (BatchEmitterFactory factory : serviceLoader) {
            InternalLogging.getLogger().info("{} class found {}", new Object[]{BatchEmitterFactory.class.getSimpleName(), factory.getClass().getName()});
            if (!factory.accepts(clientObjectFactory.getClass())) continue;
            factories.add(factory);
        }
        return factories;
    }

    private static Iterable<BatchEmitterFactory> serviceLoader(ClassLoader classLoader) {
        return ServiceLoader.load(BatchEmitterFactory.class, classLoader);
    }

    private static class NaturalLoadingOrder
    implements Comparator<BatchEmitterFactory> {
        private NaturalLoadingOrder() {
        }

        @Override
        public int compare(BatchEmitterFactory o1, BatchEmitterFactory o2) {
            if (o1.loadingOrder() == o2.loadingOrder()) {
                return 0;
            }
            return o1.loadingOrder() > o2.loadingOrder() ? 1 : -1;
        }
    }
}

