package org.appenders.log4j2.elasticsearch.hc;

/*-
 * #%L
 * log4j2-elasticsearch
 * %%
 * Copyright (C) 2018 Rafal Foltynski
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import org.apache.http.nio.util.SimpleInputBuffer;
import org.appenders.log4j2.elasticsearch.ItemSource;
import org.appenders.log4j2.elasticsearch.ReleaseCallback;

/**
 * {@code org.apache.http.nio.util.SimpleInputBuffer} backed {@link ItemSource}.
 * When it's no longer needed, {@link #release()} MUST be called to release underlying resources.
 */
public class InputBufferItemSource implements ItemSource<SimpleInputBuffer> {

    private SimpleInputBuffer source;
    private final ReleaseCallback<SimpleInputBuffer> releaseCallback;

    public InputBufferItemSource(SimpleInputBuffer source, ReleaseCallback<SimpleInputBuffer> releaseCallback) {
        this.source = source;
        this.releaseCallback = releaseCallback;
    }

    @Override
    public SimpleInputBuffer getSource() {
        return source;
    }

    /**
     * Invokes given callback
     */
    public void release() {
        releaseCallback.completed(this);
    }

}
