/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser.database;

import chapi.domain.core.CodeAnnotation;
import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.archguard.scanner.analyser.database.MysqlIdentApp;
import org.archguard.scanner.analyser.database.SimpleDbStructure;
import org.archguard.scanner.analyser.database.SqlifyKt;
import org.archguard.scanner.analyser.xml.mybatis.MybatisEntry;
import org.archguard.scanner.core.sourcecode.CodeDatabaseRelation;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/archguard/scanner/analyser/database/JvmSqlAnalyser;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "analysisByNode", "", "Lorg/archguard/scanner/core/sourcecode/CodeDatabaseRelation;", "node", "Lchapi/domain/core/CodeDataStruct;", "workspace", "", "convertMyBatis", "mybatisEntries", "", "Lorg/archguard/scanner/analyser/xml/mybatis/MybatisEntry;", "feat_datamap"})
public final class JvmSqlAnalyser {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @NotNull
    public final List<CodeDatabaseRelation> analysisByNode(@NotNull CodeDataStruct node, @NotNull String workspace) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        List relations = new ArrayList();
        CodeFunction[] $this$forEach$iv = node.getFunctions();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Object originSql;
            CodeAnnotation it;
            CodeAnnotation element$iv;
            int n2;
            CodeFunction element$iv2;
            CodeFunction function = element$iv2 = $this$forEach$iv[i];
            boolean bl = false;
            List sqls = new ArrayList();
            Set tables = new LinkedHashSet();
            CodeAnnotation[] $this$forEach$iv2 = function.getAnnotations();
            boolean $i$f$forEach2 = false;
            int n3 = $this$forEach$iv2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                it = element$iv = $this$forEach$iv2[n2];
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"Query") && !Intrinsics.areEqual((Object)it.getName(), (Object)"SqlQuery") || !(!(it.getKeyValues().length == 0))) continue;
                originSql = it.getKeyValues()[0].getValue();
                String pureValue = SqlifyKt.sqlify((String)originSql);
                if (MysqlIdentApp.INSTANCE.analysis(pureValue) != null) {
                    Collection collection = tables;
                    SimpleDbStructure simpleDbStructure = MysqlIdentApp.INSTANCE.analysis(pureValue);
                    Intrinsics.checkNotNull((Object)simpleDbStructure);
                    CollectionsKt.addAll((Collection)collection, (Iterable)simpleDbStructure.getTableNames());
                } else {
                    this.logger.warn("error for " + node.getNodeName() + '.' + function.getName() + " origin:" + (String)originSql + " \nnew:" + pureValue);
                }
                ((Collection)sqls).add(pureValue);
            }
            $this$forEach$iv2 = function.getFunctionCalls();
            $i$f$forEach2 = false;
            n3 = $this$forEach$iv2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                it = element$iv = $this$forEach$iv2[n2];
                boolean bl3 = false;
                originSql = new String[]{"."};
                String callMethodName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)it.getFunctionName(), (String[])originSql, (boolean)false, (int)0, (int)6, null));
                if (!Intrinsics.areEqual((Object)callMethodName, (Object)"createQuery") || !(!(it.getParameters().length == 0))) continue;
                originSql = it.getParameters()[0].getTypeValue();
                String pureValue = SqlifyKt.sqlify((String)originSql);
                if (MysqlIdentApp.INSTANCE.analysis(pureValue) != null) {
                    Collection collection = tables;
                    SimpleDbStructure simpleDbStructure = MysqlIdentApp.INSTANCE.analysis(pureValue);
                    Intrinsics.checkNotNull((Object)simpleDbStructure);
                    CollectionsKt.addAll((Collection)collection, (Iterable)simpleDbStructure.getTableNames());
                } else {
                    this.logger.warn("error for " + node.getNodeName() + '.' + function.getName() + " origin:" + (String)originSql + "\nnew:" + pureValue);
                }
                ((Collection)sqls).add(pureValue);
            }
            if (sqls.size() <= 0) continue;
            ((Collection)relations).add(new CodeDatabaseRelation(node.getPackage(), node.getNodeName(), function.getName(), CollectionsKt.toList((Iterable)tables), sqls));
        }
        return relations;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CodeDatabaseRelation> convertMyBatis(@NotNull List<MybatisEntry> mybatisEntries) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(mybatisEntries, (String)"mybatisEntries");
        Iterable $this$flatMap$iv = mybatisEntries;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            MybatisEntry entry = (MybatisEntry)element$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"."};
            List splits = StringsKt.split$default((CharSequence)entry.getNamespace(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String className = (String)CollectionsKt.last((List)splits);
            CollectionsKt.dropLast((List)splits, (int)1);
            String packageName = CollectionsKt.joinToString$default((Iterable)splits, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            Map<String, String> $this$map$iv = entry.getMethodSqlMap();
            boolean $i$f$map = false;
            Map<String, String> map = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry2 = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                SimpleDbStructure simpleDbStructure = MysqlIdentApp.INSTANCE.analysis((String)it.getValue());
                List tables = simpleDbStructure != null ? simpleDbStructure.getTableNames() : null;
                String string = (String)it.getKey();
                List list = tables;
                if (list == null || (list = CollectionsKt.toList((Iterable)list)) == null) {
                    list = CollectionsKt.emptyList();
                }
                collection.add(new CodeDatabaseRelation(packageName, className, string, list, CollectionsKt.listOf(it.getValue())));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }
}

