/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser.xml;

import java.io.File;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.archguard.scanner.analyser.xml.BasedXmlHandler;
import org.archguard.scanner.analyser.xml.HandlerDispatcher;
import org.archguard.scanner.analyser.xml.XmlParser;
import org.archguard.scanner.analyser.xml.mybatis.MyBatisHandler;
import org.archguard.scanner.analyser.xml.mybatis.MybatisEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/archguard/scanner/analyser/xml/XmlParser;", "", "contentHandler", "Lorg/archguard/scanner/analyser/xml/BasedXmlHandler;", "filePath", "", "handlerName", "(Lorg/archguard/scanner/analyser/xml/BasedXmlHandler;Ljava/lang/String;Ljava/lang/String;)V", "getContentHandler", "()Lorg/archguard/scanner/analyser/xml/BasedXmlHandler;", "getFilePath", "()Ljava/lang/String;", "getHandlerName", "processMyBatis", "Lorg/archguard/scanner/analyser/xml/mybatis/MybatisEntry;", "Companion", "feat_datamap"})
public final class XmlParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BasedXmlHandler contentHandler;
    @NotNull
    private final String filePath;
    @NotNull
    private final String handlerName;

    public XmlParser(@NotNull BasedXmlHandler contentHandler, @NotNull String filePath, @NotNull String handlerName) {
        Intrinsics.checkNotNullParameter((Object)contentHandler, (String)"contentHandler");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)handlerName, (String)"handlerName");
        this.contentHandler = contentHandler;
        this.filePath = filePath;
        this.handlerName = handlerName;
    }

    @NotNull
    public final BasedXmlHandler getContentHandler() {
        return this.contentHandler;
    }

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    @NotNull
    public final String getHandlerName() {
        return this.handlerName;
    }

    @Nullable
    public final MybatisEntry processMyBatis() {
        if (Intrinsics.areEqual((Object)this.handlerName, (Object)"MyBatisHandler")) {
            MyBatisHandler mybatis = (MyBatisHandler)this.contentHandler;
            return mybatis.compute(this.filePath);
        }
        return null;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Lorg/archguard/scanner/analyser/xml/XmlParser$Companion;", "", "()V", "fromFile", "Lorg/archguard/scanner/analyser/xml/XmlParser;", "filePath", "", "parseMybatis", "", "Lorg/archguard/scanner/analyser/xml/mybatis/MybatisEntry;", "path", "feat_datamap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<MybatisEntry> parseMybatis(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)new File(path), null, (int)1, null)), (Function1)parseMybatis.1.INSTANCE), (Function1)parseMybatis.2.INSTANCE));
        }

        @Nullable
        public final XmlParser fromFile(@NotNull String filePath) throws ParserConfigurationException, SAXException {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            File inputSource = new File(filePath);
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            HandlerDispatcher dispatcher = new HandlerDispatcher();
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", dispatcher);
            try {
                parser.parse(inputSource, (DefaultHandler)dispatcher);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(XmlParser.class).info(e.toString());
                return null;
            }
            BasedXmlHandler basedXmlHandler = dispatcher.getContentHandler();
            if (basedXmlHandler == null) {
                return null;
            }
            BasedXmlHandler contentHandler = basedXmlHandler;
            XMLReader xmlReader = parser.getXMLReader();
            xmlReader.setContentHandler(contentHandler);
            xmlReader.parse(filePath);
            return new XmlParser(contentHandler, filePath, dispatcher.handlerName());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

