/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.apache.ibatis.annotations.Lang;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.apache.ibatis.builder.annotation.ProviderMethodResolver;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.ParamNameResolver;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;

public class ProviderSqlSource
implements SqlSource {
    private final Configuration configuration;
    private final Class<?> providerType;
    private final LanguageDriver languageDriver;
    private final Method mapperMethod;
    private final Method providerMethod;
    private final String[] providerMethodArgumentNames;
    private final Class<?>[] providerMethodParameterTypes;
    private final ProviderContext providerContext;
    private final Integer providerContextIndex;

    @Deprecated
    public ProviderSqlSource(Configuration configuration, Object provider) {
        this(configuration, provider, null, null);
    }

    @Deprecated
    public ProviderSqlSource(Configuration configuration, Object provider, Class<?> mapperType, Method mapperMethod) {
        this(configuration, (Annotation)provider, mapperType, mapperMethod);
    }

    public ProviderSqlSource(Configuration configuration, Annotation provider, Class<?> mapperType, Method mapperMethod) {
        String candidateProviderMethodName;
        Method candidateProviderMethod = null;
        try {
            this.configuration = configuration;
            this.mapperMethod = mapperMethod;
            Lang lang = mapperMethod == null ? null : mapperMethod.getAnnotation(Lang.class);
            this.languageDriver = configuration.getLanguageDriver(lang == null ? null : lang.value());
            this.providerType = this.getProviderType(configuration, provider, mapperMethod);
            candidateProviderMethodName = (String)provider.annotationType().getMethod("method", new Class[0]).invoke((Object)provider, new Object[0]);
            if (candidateProviderMethodName.length() == 0 && ProviderMethodResolver.class.isAssignableFrom(this.providerType)) {
                candidateProviderMethod = ((ProviderMethodResolver)this.providerType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).resolveMethod(new ProviderContext(mapperType, mapperMethod, configuration.getDatabaseId()));
            }
            if (candidateProviderMethod == null) {
                candidateProviderMethodName = candidateProviderMethodName.length() == 0 ? "provideSql" : candidateProviderMethodName;
                for (Method m : this.providerType.getMethods()) {
                    if (!candidateProviderMethodName.equals(m.getName()) || !CharSequence.class.isAssignableFrom(m.getReturnType())) continue;
                    if (candidateProviderMethod != null) {
                        throw new BuilderException("Error creating SqlSource for SqlProvider. Method '" + candidateProviderMethodName + "' is found multiple in SqlProvider '" + this.providerType.getName() + "'. Sql provider method can not overload.");
                    }
                    candidateProviderMethod = m;
                }
            }
        }
        catch (BuilderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuilderException("Error creating SqlSource for SqlProvider.  Cause: " + e, e);
        }
        if (candidateProviderMethod == null) {
            throw new BuilderException("Error creating SqlSource for SqlProvider. Method '" + candidateProviderMethodName + "' not found in SqlProvider '" + this.providerType.getName() + "'.");
        }
        this.providerMethod = candidateProviderMethod;
        this.providerMethodArgumentNames = new ParamNameResolver(configuration, this.providerMethod).getNames();
        this.providerMethodParameterTypes = this.providerMethod.getParameterTypes();
        ProviderContext candidateProviderContext = null;
        Integer candidateProviderContextIndex = null;
        for (int i = 0; i < this.providerMethodParameterTypes.length; ++i) {
            Class<?> parameterType = this.providerMethodParameterTypes[i];
            if (parameterType != ProviderContext.class) continue;
            if (candidateProviderContext != null) {
                throw new BuilderException("Error creating SqlSource for SqlProvider. ProviderContext found multiple in SqlProvider method (" + this.providerType.getName() + "." + this.providerMethod.getName() + "). ProviderContext can not define multiple in SqlProvider method argument.");
            }
            candidateProviderContext = new ProviderContext(mapperType, mapperMethod, configuration.getDatabaseId());
            candidateProviderContextIndex = i;
        }
        this.providerContext = candidateProviderContext;
        this.providerContextIndex = candidateProviderContextIndex;
    }

    @Override
    public BoundSql getBoundSql(Object parameterObject) {
        SqlSource sqlSource = this.createSqlSource(parameterObject);
        return sqlSource.getBoundSql(parameterObject);
    }

    private SqlSource createSqlSource(Object parameterObject) {
        try {
            String sql;
            if (parameterObject instanceof Map) {
                int bindParameterCount = this.providerMethodParameterTypes.length - (this.providerContext == null ? 0 : 1);
                if (bindParameterCount == 1 && this.providerMethodParameterTypes[Integer.valueOf(0).equals(this.providerContextIndex) ? 1 : 0].isAssignableFrom(parameterObject.getClass())) {
                    sql = this.invokeProviderMethod(this.extractProviderMethodArguments(parameterObject));
                } else {
                    Map params2 = (Map)parameterObject;
                    sql = this.invokeProviderMethod(this.extractProviderMethodArguments(params2, this.providerMethodArgumentNames));
                }
            } else if (this.providerMethodParameterTypes.length == 0) {
                sql = this.invokeProviderMethod(new Object[0]);
            } else if (this.providerMethodParameterTypes.length == 1) {
                sql = this.providerContext == null ? this.invokeProviderMethod(parameterObject) : this.invokeProviderMethod(this.providerContext);
            } else if (this.providerMethodParameterTypes.length == 2) {
                sql = this.invokeProviderMethod(this.extractProviderMethodArguments(parameterObject));
            } else {
                throw new BuilderException("Cannot invoke SqlProvider method '" + this.providerMethod + "' with specify parameter '" + (parameterObject == null ? null : parameterObject.getClass()) + "' because SqlProvider method arguments for '" + this.mapperMethod + "' is an invalid combination.");
            }
            Class parameterType = parameterObject == null ? Object.class : parameterObject.getClass();
            return this.languageDriver.createSqlSource(this.configuration, sql, parameterType);
        }
        catch (BuilderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuilderException("Error invoking SqlProvider method '" + this.providerMethod + "' with specify parameter '" + (parameterObject == null ? null : parameterObject.getClass()) + "'.  Cause: " + this.extractRootCause(e), e);
        }
    }

    private Throwable extractRootCause(Exception e) {
        Throwable cause = e;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    private Object[] extractProviderMethodArguments(Object parameterObject) {
        if (this.providerContext != null) {
            Object[] args = new Object[2];
            args[this.providerContextIndex.intValue() == 0 ? 1 : 0] = parameterObject;
            args[this.providerContextIndex.intValue()] = this.providerContext;
            return args;
        }
        return new Object[]{parameterObject};
    }

    private Object[] extractProviderMethodArguments(Map<String, Object> params2, String[] argumentNames) {
        Object[] args = new Object[argumentNames.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.providerContextIndex != null && this.providerContextIndex == i ? this.providerContext : params2.get(argumentNames[i]);
        }
        return args;
    }

    private String invokeProviderMethod(Object ... args) throws Exception {
        CharSequence sql;
        Object targetObject = null;
        if (!Modifier.isStatic(this.providerMethod.getModifiers())) {
            targetObject = this.providerType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return (sql = (CharSequence)this.providerMethod.invoke(targetObject, args)) != null ? sql.toString() : null;
    }

    private Class<?> getProviderType(Configuration configuration, Annotation providerAnnotation, Method mapperMethod) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class type = (Class)providerAnnotation.annotationType().getMethod("type", new Class[0]).invoke((Object)providerAnnotation, new Object[0]);
        Class value = (Class)providerAnnotation.annotationType().getMethod("value", new Class[0]).invoke((Object)providerAnnotation, new Object[0]);
        if (value == Void.TYPE && type == Void.TYPE) {
            if (configuration.getDefaultSqlProviderType() != null) {
                return configuration.getDefaultSqlProviderType();
            }
            throw new BuilderException("Please specify either 'value' or 'type' attribute of @" + providerAnnotation.annotationType().getSimpleName() + " at the '" + mapperMethod.toString() + "'.");
        }
        if (value != Void.TYPE && type != Void.TYPE && value != type) {
            throw new BuilderException("Cannot specify different class on 'value' and 'type' attribute of @" + providerAnnotation.annotationType().getSimpleName() + " at the '" + mapperMethod.toString() + "'.");
        }
        return value == Void.TYPE ? type : value;
    }
}

