/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.core.sourcecode;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FileWalkDirection;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.archguard.scanner.core.sourcecode.ModuleIdentify;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\fJ\u0016\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0017"}, d2={"Lorg/archguard/scanner/core/sourcecode/ModuleIdentify;", "", "()V", "ROOT", "", "SEPARATOR", "SETTINGS_FILES", "", "[Ljava/lang/String;", "containsFiles", "", "sourcePath", "Ljava/io/File;", "hasModule", "file", "isGradle", "it", "isMaven", "isRootModule", "path", "isSubModule", "lookupModuleName", "base", "scanner_core"})
public final class ModuleIdentify {
    @NotNull
    public static final ModuleIdentify INSTANCE = new ModuleIdentify();
    @NotNull
    private static final String SEPARATOR = ":";
    @NotNull
    private static final String ROOT = "root";
    @NotNull
    private static final String[] SETTINGS_FILES;

    private ModuleIdentify() {
    }

    @NotNull
    public final String lookupModuleName(@NotNull File file, @NotNull File base) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        String[] stringArray = new String[]{"src" + File.separator};
        List srcSplit = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        File srcPath = new File((String)srcSplit.get(0));
        if (this.isRootModule(srcPath)) {
            return ROOT;
        }
        if (Intrinsics.areEqual((Object)file.getAbsolutePath(), (Object)base.getAbsolutePath())) {
            return ROOT;
        }
        if (this.isSubModule(srcPath)) {
            File relativePath = FilesKt.relativeTo((File)srcPath, (File)base);
            String string2 = relativePath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"relativePath.path");
            CharSequence charSequence = string2;
            String[] stringArray2 = new String[1];
            Intrinsics.checkNotNullExpressionValue((Object)File.separator, (String)"separator");
            List split = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            return "root:" + CollectionsKt.joinToString$default((Iterable)split, (CharSequence)SEPARATOR, null, null, (int)0, null, null, (int)62, null);
        }
        return SEPARATOR;
    }

    private final boolean isGradle(File it) {
        return Intrinsics.areEqual((Object)it.getName(), (Object)"build.gradle") || Intrinsics.areEqual((Object)it.getName(), (Object)"build.gradle.kts");
    }

    private final boolean isMaven(File it) {
        return Intrinsics.areEqual((Object)it.getName(), (Object)"pom.xml");
    }

    public final boolean isRootModule(@NotNull File path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!path.exists()) {
            return false;
        }
        if (!path.isDirectory()) {
            return false;
        }
        for (String buildFileName : SETTINGS_FILES) {
            if (!new File(path, buildFileName).exists()) continue;
            return true;
        }
        return new File(path, "pom.xml").exists();
    }

    public final boolean isSubModule(@NotNull File path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!path.exists()) {
            return false;
        }
        if (!path.isDirectory()) {
            return false;
        }
        return this.containsFiles(new File(path, "src"));
    }

    private final boolean hasModule(File file) {
        return this.isGradle(file) || this.isMaven(file);
    }

    private final boolean containsFiles(File sourcePath) {
        boolean bl;
        boolean isIncludeSource;
        boolean bl2 = isIncludeSource = sourcePath.exists() && sourcePath.isDirectory();
        if (isIncludeSource) {
            File file = sourcePath.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"sourcePath.parentFile");
            bl = !((Collection)SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk((File)file, (FileWalkDirection)FileWalkDirection.TOP_DOWN).maxDepth(1)), (Function1)containsFiles.1.INSTANCE))).isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$hasModule(ModuleIdentify $this, File file) {
        return $this.hasModule(file);
    }

    static {
        String[] stringArray = new String[]{"settings.gradle", "settings.gradle.kts"};
        SETTINGS_FILES = stringArray;
    }
}

