/*
 * Decompiled with CFR 0.152.
 */
package compozitor.template.core.interfaces;

import compozitor.template.core.infra.JoinableClassLoader;
import compozitor.template.core.infra.MacrosLoader;
import compozitor.template.core.infra.ResourceUri;
import compozitor.template.core.infra.S3Resource;
import compozitor.template.core.infra.S3ResourceLoader;
import compozitor.template.core.interfaces.Capitalize;
import compozitor.template.core.interfaces.LowerCase;
import compozitor.template.core.interfaces.Render;
import compozitor.template.core.interfaces.S3Bucket;
import compozitor.template.core.interfaces.TemplateEngine;
import compozitor.template.core.interfaces.TrimAll;
import compozitor.template.core.interfaces.Uncapitalize;
import compozitor.template.core.interfaces.UpperCase;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.velocity.app.event.implement.IncludeRelativePath;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;

public class TemplateEngineBuilder {
    public static final String USERDIRECTIVE_TEMPLATES_LOCATION = "userdirective.templates.location";
    private static final String USER_DIRECTIVE = "userdirective";
    private final RuntimeServices target;
    private final Set<Class<? extends Directive>> directives = new HashSet<Class<? extends Directive>>();
    private final Set<String> macros = new HashSet<String>();
    private final JoinableClassLoader classLoader;

    private TemplateEngineBuilder() {
        this.target = new RuntimeInstance();
        this.classLoader = JoinableClassLoader.create().join(this.getClass().getClassLoader());
        this.init();
    }

    public static TemplateEngineBuilder create() {
        return new TemplateEngineBuilder();
    }

    private void init() {
        this.target.addProperty("velocimacro.library", (Object)"");
        this.target.addProperty("runtime.log.invalid.references", (Object)"true");
        this.target.addProperty("velocimacro.permissions.allow.inline", (Object)"true");
        this.target.addProperty("velocimacro.permissions.allow.inline.to.replace.global", (Object)"true");
        this.target.addProperty("eventhandler.include.class", (Object)IncludeRelativePath.class.getName());
        this.target.addProperty("runtime.log.logsystem.log4j.logger", (Object)"root");
        this.addDirectives(Capitalize.class, LowerCase.class, Render.class, TrimAll.class, Uncapitalize.class, UpperCase.class);
    }

    public TemplateEngineBuilder addClassLoader(ClassLoader classLoader) {
        this.classLoader.join(classLoader);
        return this;
    }

    public TemplateEngineBuilder withClasspathTemplateLoader() {
        this.target.addProperty("resource.loader", (Object)"cp");
        this.target.addProperty("cp.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        return this;
    }

    public TemplateEngineBuilder withPathTemplateLoader(Path location) {
        this.target.addProperty("resource.loader", (Object)"file");
        this.target.addProperty("file.resource.loader.class", (Object)FileResourceLoader.class.getName());
        this.target.addProperty("file.resource.loader.path", (Object)location.toString());
        this.target.addProperty("file.resource.loader.cache", (Object)"false");
        return this;
    }

    public TemplateEngineBuilder withS3TemplateLoader(S3Bucket s3Bucket) {
        this.target.addProperty("resource.loader", (Object)S3Resource.resourceName());
        this.target.addProperty(S3Resource.loader.propertyKey(), (Object)S3ResourceLoader.class.getName());
        this.target.addProperty(S3Resource.bucket.propertyKey(), (Object)s3Bucket.name());
        return this;
    }

    public TemplateEngineBuilder addDirectives(Collection<Class<? extends Directive>> directives) {
        this.directives.addAll(directives);
        this.target.addProperty(USER_DIRECTIVE, (Object)this.toUserDirectiveValue());
        return this;
    }

    public TemplateEngineBuilder addDirectives(Class<? extends Directive> ... directives) {
        return this.addDirectives(Arrays.asList(directives));
    }

    public TemplateEngineBuilder withDirectivePath(Path path) {
        this.target.setProperty(USERDIRECTIVE_TEMPLATES_LOCATION, (Object)path.toString());
        return this;
    }

    public TemplateEngineBuilder loadMacros(Path path, Consumer<Iterable<String>> added) {
        Stream<String> macroFiles = MacrosLoader.create(this.classLoader).list(path);
        macroFiles.forEach(this.macros::add);
        added.accept(this.macros);
        return this.setMacros();
    }

    public TemplateEngineBuilder addMacros(Path path, String ... files) {
        Arrays.asList(files).forEach(file -> this.macros.add(new ResourceUri(path.toString(), (String)file).toString()));
        return this.setMacros();
    }

    private TemplateEngineBuilder setMacros() {
        this.target.setProperty("velocimacro.library", (Object)this.macros.stream().collect(Collectors.joining(",")));
        return this;
    }

    public TemplateEngine build() {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.classLoader);
            this.target.init();
        }
        finally {
            thread.setContextClassLoader(loader);
        }
        return new TemplateEngine(this.target);
    }

    public Iterable<Class<? extends Directive>> directives() {
        return this.directives;
    }

    private String toUserDirectiveValue() {
        StringBuffer csv = new StringBuffer();
        for (Class<? extends Directive> value : this.directives) {
            csv.append(value.getName()).append(",");
        }
        csv.delete(csv.length() - 1, csv.length());
        return csv.toString();
    }
}

