/*
 * Decompiled with CFR 0.152.
 */
package migrami.sql.interfaces;

import migrami.sql.infra.DatabaseVendor;
import toolbox.validation.interfaces.CompositeValidation;
import toolbox.validation.interfaces.ValueValidation;

class DatabaseConfiguration {
    private final String url;
    private final String user;
    private final String password;
    private final DatabaseVendor vendor;

    private DatabaseConfiguration(String url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.vendor = DatabaseVendor.detectDatabase(url);
    }

    public static DatabaseConfiguration create(String url, String user, String password) {
        return new DatabaseConfiguration(url, user, password);
    }

    public String password() {
        return this.password;
    }

    public String url() {
        return this.url;
    }

    public String user() {
        return this.user;
    }

    public DatabaseVendor vendor() {
        return this.vendor;
    }

    public void validate() {
        CompositeValidation.create().add(ValueValidation.notEmpty((String)this.url).withMessage("Invalid database url", new Object[0])).add(ValueValidation.notEmpty((String)this.user).withMessage("Invalid database user", new Object[0])).add(ValueValidation.notNull((Object)((Object)this.vendor)).withMessage("Database is not supported yet", new Object[0])).validate();
    }
}

