/*
 * Decompiled with CFR 0.152.
 */
package migrami.sql.interfaces;

import migrami.core.interfaces.Migrami;
import migrami.core.interfaces.MigramiBuilder;
import migrami.core.interfaces.MigramiChecksumFactory;
import migrami.core.interfaces.MigramiSnapshotRepository;
import migrami.sql.interfaces.DatabaseConfiguration;
import migrami.sql.interfaces.MigramiSQLEngine;
import migrami.sql.interfaces.TableSnapshotRepository;

public class MigramiSQLEngineBuilder
extends MigramiBuilder<MigramiSQLEngineBuilder> {
    private DatabaseConfiguration configuration;

    public MigramiSQLEngineBuilder withDatasource(String url, String username, String password) {
        this.configuration = DatabaseConfiguration.create(url, username, password);
        return this;
    }

    public MigramiSQLEngineBuilder withTableSnapshotRepository() {
        return (MigramiSQLEngineBuilder)this.withSnapshotRepository(new TableSnapshotRepository());
    }

    public MigramiSQLEngineBuilder withTableSnapshotRepository(String customTableName) {
        return (MigramiSQLEngineBuilder)this.withSnapshotRepository(new TableSnapshotRepository(customTableName));
    }

    protected void validate() {
        this.configuration.validate();
        super.validate();
    }

    public Migrami build() {
        this.validate();
        MigramiSnapshotRepository snapshotRepository = (MigramiSnapshotRepository)this.repository.get();
        MigramiChecksumFactory checksumFactory = (MigramiChecksumFactory)this.checksumFactory.get();
        return new MigramiSQLEngine(this.configuration, this.scriptLoaders, checksumFactory, snapshotRepository);
    }

    private MigramiSQLEngineBuilder() {
    }

    public static MigramiSQLEngineBuilder create() {
        return new MigramiSQLEngineBuilder();
    }
}

