/*
 * Decompiled with CFR 0.152.
 */
package migrami.sql.interfaces;

import java.io.BufferedReader;
import java.util.function.Consumer;
import migrami.core.interfaces.MigramiScriptBody;

public class SQLStatements {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final String DELIMITER = ";";

    public static void process(MigramiScriptBody body, Consumer<String> consumer) {
        StringBuilder statement = new StringBuilder();
        try {
            BufferedReader lineReader = new BufferedReader(body.toReader());
            String line = null;
            while ((line = lineReader.readLine()) != null) {
                if (!SQLStatements.readyForExecution(statement, line)) continue;
                consumer.accept(statement.toString());
                statement.setLength(0);
                line = null;
            }
            if (statement.length() > 0) {
                consumer.accept(statement.toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error on migration file parsing", e);
        }
    }

    private static boolean readyForExecution(StringBuilder command, String line) {
        String trimmedLine = line.trim();
        if (SQLStatements.lineIsComment(trimmedLine)) {
            return false;
        }
        if (trimmedLine.endsWith(DELIMITER)) {
            command.append(line.substring(0, line.lastIndexOf(DELIMITER)));
            return true;
        }
        command.append(line);
        command.append(LINE_SEPARATOR);
        return false;
    }

    private static boolean lineIsComment(String trimmedLine) {
        return trimmedLine.startsWith("//") || trimmedLine.startsWith("--");
    }

    private SQLStatements() {
    }

    private static SQLStatements create() {
        return new SQLStatements();
    }
}

