/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.core.serial.rxtx;

import gnu.io.CommPortIdentifier;
import java.util.Enumeration;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.ardulink.core.linkmanager.LinkConfig;
import org.ardulink.core.proto.api.Protocol;
import org.ardulink.core.proto.api.Protocols;
import org.ardulink.core.proto.impl.ArdulinkProtocol2;
import org.ardulink.util.Iterables;
import org.ardulink.util.Lists;

@LinkConfig.I18n(value="message")
public class SerialLinkConfig
implements LinkConfig {
    @LinkConfig.Named(value="port")
    private String port;
    @LinkConfig.Named(value="baudrate")
    @Min(value=1L)
    private int baudrate = 115200;
    @LinkConfig.Named(value="proto")
    private Protocol protoName = this.useProtoOrFallback(ArdulinkProtocol2.instance());
    @LinkConfig.Named(value="qos")
    private boolean qos;
    @Min(value=0L)
    @Max(value=59L)
    @LinkConfig.Named(value="waitsecs")
    private int waitsecs = 10;
    @LinkConfig.Named(value="pingprobe")
    private boolean pingprobe = true;
    @LinkConfig.Named(value="searchport")
    private boolean searchport;

    public int getBaudrate() {
        return this.baudrate;
    }

    private Protocol useProtoOrFallback(Protocol prefered) {
        return this.isAvailable(prefered) ? prefered : (Protocol)Iterables.getFirst((Iterable)Protocols.list()).orNull();
    }

    private boolean isAvailable(Protocol prefered) {
        return this.availableProtos().contains(prefered.getName());
    }

    public String getPort() {
        return this.port;
    }

    @LinkConfig.ChoiceFor(value="port")
    public List<String> listPorts() {
        List ports = Lists.newArrayList((Object[])new String[0]);
        for (CommPortIdentifier portIdentifier : this.portIdentifiers()) {
            if (portIdentifier.getPortType() != 1) continue;
            ports.add(portIdentifier.getName());
        }
        return ports;
    }

    @LinkConfig.ChoiceFor(value="proto")
    public List<String> availableProtos() {
        return Protocols.names();
    }

    public String getProtoName() {
        return this.protoName == null ? null : this.protoName.getName();
    }

    public Protocol getProto() {
        return Protocols.getByName((String)this.getProtoName());
    }

    public int getWaitsecs() {
        return this.waitsecs;
    }

    public boolean isPingprobe() {
        return this.pingprobe;
    }

    public boolean isQos() {
        return this.qos;
    }

    private Iterable<CommPortIdentifier> portIdentifiers() {
        return Iterables.forEnumeration((Enumeration)CommPortIdentifier.getPortIdentifiers());
    }

    public void setBaudrate(int baudrate) {
        this.baudrate = baudrate;
    }

    public void setPingprobe(boolean pingprobe) {
        this.pingprobe = pingprobe;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setProtoName(String protoName) {
        this.protoName = Protocols.getByName((String)protoName);
    }

    public void setQos(boolean qos) {
        this.qos = qos;
    }

    public void setWaitsecs(int waitsecs) {
        this.waitsecs = waitsecs;
    }
}

