/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.core.serial.rxtx;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.ardulink.core.Connection;
import org.ardulink.core.ConnectionBasedLink;
import org.ardulink.core.Link;
import org.ardulink.core.StreamConnection;
import org.ardulink.core.convenience.LinkDelegate;
import org.ardulink.core.linkmanager.LinkFactory;
import org.ardulink.core.qos.QosLink;
import org.ardulink.core.serial.rxtx.SerialLinkConfig;
import org.ardulink.util.Preconditions;

public class SerialLinkFactory
implements LinkFactory<SerialLinkConfig> {
    public String getName() {
        return "serial";
    }

    public LinkDelegate newLink(SerialLinkConfig config) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException {
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)config.getPort());
        Preconditions.checkState((!portIdentifier.isCurrentlyOwned() ? 1 : 0) != 0, (String)"Port %s is currently in use", (Object[])new Object[]{config.getPort()});
        final SerialPort serialPort = this.serialPort(config, portIdentifier);
        StreamConnection connection = new StreamConnection(serialPort.getInputStream(), serialPort.getOutputStream(), config.getProto());
        ConnectionBasedLink connectionBasedLink = new ConnectionBasedLink((Connection)connection, config.getProto());
        ConnectionBasedLink link = config.isQos() ? new QosLink((Link)connectionBasedLink) : connectionBasedLink;
        this.waitForArdulink(config, connectionBasedLink);
        return new LinkDelegate((Link)link){

            public void close() throws IOException {
                super.close();
                serialPort.close();
            }
        };
    }

    private void waitForArdulink(SerialLinkConfig config, ConnectionBasedLink link) {
        if (config.isPingprobe()) {
            Preconditions.checkState((boolean)link.waitForArduinoToBoot(config.getWaitsecs(), TimeUnit.SECONDS), (String)"Waited for arduino to boot but no response received", (Object[])new Object[0]);
        } else {
            try {
                TimeUnit.SECONDS.sleep(config.getWaitsecs());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private SerialPort serialPort(SerialLinkConfig config, CommPortIdentifier portIdentifier) throws PortInUseException, UnsupportedCommOperationException {
        SerialPort serialPort = (SerialPort)portIdentifier.open("RTBug_network", 2000);
        serialPort.setSerialPortParams(config.getBaudrate(), 8, 1, 0);
        return serialPort;
    }

    public SerialLinkConfig newLinkConfig() {
        return new SerialLinkConfig();
    }
}

