/*
 * Decompiled with CFR 0.152.
 */
package org.arecap.cop.proxy;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;
import org.arecap.cop.proxy.ContextOrientedMethodInvocation;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.util.Assert;

public class WrapMethodInvocation
implements MethodInvocation {
    private final Set<MethodInvocation> proceedMethodInvocationChain = new LinkedHashSet<MethodInvocation>();
    private final MethodInvocation jointPoint;

    public WrapMethodInvocation(MethodInvocation jointPoint) {
        this.jointPoint = jointPoint;
    }

    public void add(MethodInvocation proceedMethodInvocation) {
        this.proceedMethodInvocationChain.add(proceedMethodInvocation);
    }

    public void addAll(Set<MethodInvocation> proceedMethodInvocations) {
        this.proceedMethodInvocationChain.addAll(proceedMethodInvocations);
    }

    public void setArguments(Object ... arguments) {
        Assert.isAssignable(ProxyMethodInvocation.class, this.jointPoint.getClass());
        ((ProxyMethodInvocation)this.jointPoint).setArguments(arguments);
    }

    public Method getMethod() {
        return this.jointPoint.getMethod();
    }

    public Object[] getArguments() {
        return this.jointPoint.getArguments();
    }

    public Object proceed() throws Throwable {
        MethodInvocation methodInvocation = this.proceedMethodInvocationChain.iterator().next();
        this.proceedMethodInvocationChain.remove(methodInvocation);
        if (this.proceedMethodInvocationChain.isEmpty()) {
            return methodInvocation.proceed();
        }
        return new ContextOrientedMethodInvocation(methodInvocation.getThis(), methodInvocation.getMethod(), new Object[]{this}).proceed();
    }

    public Object getThis() {
        return this.jointPoint.getThis();
    }

    public AccessibleObject getStaticPart() {
        return this.jointPoint.getStaticPart();
    }
}

