/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.fastagi;

import java.io.IOException;
import net.sf.asterisk.fastagi.AGIChannel;
import net.sf.asterisk.fastagi.AGIException;
import net.sf.asterisk.fastagi.AGIReader;
import net.sf.asterisk.fastagi.AGIRequest;
import net.sf.asterisk.fastagi.AGIScript;
import net.sf.asterisk.fastagi.AGIWriter;
import net.sf.asterisk.fastagi.MappingStrategy;
import net.sf.asterisk.fastagi.command.VerboseCommand;
import net.sf.asterisk.fastagi.impl.AGIChannelImpl;
import net.sf.asterisk.fastagi.impl.AGIReaderImpl;
import net.sf.asterisk.fastagi.impl.AGIWriterImpl;
import net.sf.asterisk.io.SocketConnectionFacade;
import net.sf.asterisk.util.Log;
import net.sf.asterisk.util.LogFactory;

public class AGIConnectionHandler
implements Runnable {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final ThreadLocal channel = new ThreadLocal();
    private SocketConnectionFacade socket;
    private MappingStrategy mappingStrategy;

    public AGIConnectionHandler(SocketConnectionFacade socket, MappingStrategy mappingStrategy) {
        this.socket = socket;
        this.mappingStrategy = mappingStrategy;
    }

    protected AGIReader createReader() {
        return new AGIReaderImpl(this.socket);
    }

    protected AGIWriter createWriter() {
        return new AGIWriterImpl(this.socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            AGIReader reader = this.createReader();
            AGIWriter writer = this.createWriter();
            AGIRequest request = reader.readRequest();
            AGIChannelImpl channel = new AGIChannelImpl(writer, reader);
            AGIScript script = this.mappingStrategy.determineScript(request);
            Thread thread = Thread.currentThread();
            String threadName = thread.getName();
            AGIConnectionHandler.channel.set(channel);
            if (script != null) {
                this.logger.info("Begin AGIScript " + script.getClass().getName() + " on " + threadName);
                script.service(request, channel);
                this.logger.info("End AGIScript " + script.getClass().getName() + " on " + threadName);
            } else {
                String error = "No script configured for " + request.getRequestURL();
                channel.sendCommand(new VerboseCommand(error, 1));
                this.logger.error(error);
            }
        }
        catch (AGIException e) {
            this.logger.error("AGIException while handling request", e);
        }
        catch (Exception e) {
            this.logger.error("Unexpected Exception while handling request", e);
        }
        finally {
            channel.set(null);
            try {
                this.socket.close();
            }
            catch (IOException e) {}
        }
    }

    static AGIChannel getChannel() {
        return (AGIChannel)channel.get();
    }
}

