/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.fastagi;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.asterisk.fastagi.AGIRequest;
import net.sf.asterisk.fastagi.AGIScript;
import net.sf.asterisk.fastagi.MappingStrategy;
import net.sf.asterisk.util.Log;
import net.sf.asterisk.util.LogFactory;

public class ResourceBundleMappingStrategy
implements MappingStrategy {
    private static final String DEFAULT_RESOURCE_BUNDLE_NAME = "fastagi-mapping";
    private final Log logger = LogFactory.getLog(this.getClass());
    private String resourceBundleName = "fastagi-mapping";
    private Map mappings = null;

    public void setResourceBundleName(String propertiesName) {
        this.resourceBundleName = propertiesName;
    }

    private void loadResourceBundle() {
        ResourceBundle resourceBundle;
        this.mappings = new HashMap();
        try {
            resourceBundle = ResourceBundle.getBundle(this.resourceBundleName);
        }
        catch (MissingResourceException e) {
            this.logger.error("Resource bundle " + this.resourceBundleName + " is missing.");
            return;
        }
        Enumeration<String> keys = resourceBundle.getKeys();
        while (keys.hasMoreElements()) {
            String scriptName = keys.nextElement();
            String className = resourceBundle.getString(scriptName);
            AGIScript agiScript = this.createAGIScriptInstance(className);
            if (agiScript == null) continue;
            this.mappings.put(scriptName, agiScript);
        }
    }

    private AGIScript createAGIScriptInstance(String className) {
        AGIScript agiScript;
        try {
            Class<?> agiScriptClass = Class.forName(className);
            Constructor<?> constructor = agiScriptClass.getConstructor(new Class[0]);
            agiScript = (AGIScript)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("Unable to create AGIScript instance of type " + className);
            return null;
        }
        return agiScript;
    }

    public AGIScript determineScript(AGIRequest request) {
        if (this.mappings == null) {
            this.loadResourceBundle();
        }
        return (AGIScript)this.mappings.get(request.getScript());
    }
}

