/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.fastagi.command;

import net.sf.asterisk.fastagi.command.AGICommand;

public class GetDataCommand
extends AGICommand {
    private static final long serialVersionUID = 3978141041352128820L;
    private static final int DEFAULT_MAX_DIGITS = 1024;
    private static final int DEFAULT_TIMEOUT = 0;
    private String file;
    private int timeout;
    private int maxDigits;

    public GetDataCommand(String file) {
        this.file = file;
        this.timeout = 0;
        this.maxDigits = 1024;
    }

    public GetDataCommand(String file, int timeout) {
        this.file = file;
        this.timeout = timeout;
        this.maxDigits = 1024;
    }

    public GetDataCommand(String file, int timeout, int maxDigits) throws IllegalArgumentException {
        if (maxDigits < 1 || maxDigits > 1024) {
            throw new IllegalArgumentException("maxDigits must be in [1..1024]");
        }
        this.file = file;
        this.timeout = timeout;
        this.maxDigits = maxDigits;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getMaxDigits() {
        return this.maxDigits;
    }

    public void setMaxDigits(int maxDigits) throws IllegalArgumentException {
        if (maxDigits < 1 || maxDigits > 1024) {
            throw new IllegalArgumentException("maxDigits must be in [1..1024]");
        }
        this.maxDigits = maxDigits;
    }

    public String buildCommand() {
        if (this.maxDigits == 1024) {
            if (this.timeout == 0) {
                return "GET DATA " + this.escapeAndQuote(this.file);
            }
            return "GET DATA " + this.escapeAndQuote(this.file) + " " + this.timeout;
        }
        return "GET DATA " + this.escapeAndQuote(this.file) + " " + this.timeout + " " + this.maxDigits;
    }
}

