/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.fastagi.reply.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.asterisk.fastagi.reply.AGIReply;

public class AGIReplyImpl
implements Serializable,
AGIReply {
    private static final Pattern STATUS_PATTERN = Pattern.compile("^(\\d{3})[ -]");
    private static final Pattern RESULT_PATTERN = Pattern.compile("^200 result= *(\\S+)");
    private static final Pattern PARENTHESIS_PATTERN = Pattern.compile("^200 result=\\S* +\\((.*)\\)");
    private static final Pattern ADDITIONAL_ATTRIBUTES_PATTERN = Pattern.compile("^200 result=\\S* +(\\(.*\\) )?(.+)$");
    private static final Pattern ADDITIONAL_ATTRIBUTE_PATTERN = Pattern.compile("(\\S+)=(\\S+)");
    private static final Pattern SYNOPSIS_PATTERN = Pattern.compile("^\\s*Usage:\\s*(.*)\\s*$");
    private static final String END_OF_PROPER_USAGE = "520 End of proper usage.";
    private Matcher matcher;
    private static final long serialVersionUID = 3256727294671337012L;
    private List lines;
    private String firstLine;
    private String result;
    private int status;
    private Map attributes;
    private String extra;
    private String synopsis;
    private String usage;
    private boolean resultCreated;
    private boolean statusCreated;
    private boolean attributesCreated;
    private boolean extraCreated;
    private boolean synopsisCreated;

    public AGIReplyImpl() {
    }

    public AGIReplyImpl(List lines) {
        this.lines = lines;
        try {
            this.firstLine = (String)lines.get(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getFirstLine() {
        return this.firstLine;
    }

    public List getLines() {
        return this.lines;
    }

    public int getResultCode() {
        String result = this.getResult();
        if (result == null) {
            return -1;
        }
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public char getResultCodeAsChar() {
        int resultCode = this.getResultCode();
        if (resultCode < 0) {
            return '\u0000';
        }
        return (char)resultCode;
    }

    public String getResult() {
        if (this.resultCreated) {
            return this.result;
        }
        this.matcher = RESULT_PATTERN.matcher(this.firstLine);
        if (this.matcher.find()) {
            this.result = this.matcher.group(1);
        }
        this.resultCreated = true;
        return this.result;
    }

    public int getStatus() {
        if (this.statusCreated) {
            return this.status;
        }
        this.matcher = STATUS_PATTERN.matcher(this.firstLine);
        if (this.matcher.find()) {
            this.status = Integer.parseInt(this.matcher.group(1));
        }
        this.statusCreated = true;
        return this.status;
    }

    public String getAttribute(String name) {
        if (this.getStatus() != 200) {
            return null;
        }
        if ("result".equalsIgnoreCase(name)) {
            return this.getResult();
        }
        if (!this.attributesCreated) {
            this.matcher = ADDITIONAL_ATTRIBUTES_PATTERN.matcher(this.firstLine);
            if (this.matcher.find()) {
                this.attributes = new HashMap();
                String s = this.matcher.group(2);
                Matcher attributeMatcher = ADDITIONAL_ATTRIBUTE_PATTERN.matcher(s);
                while (attributeMatcher.find()) {
                    String key = attributeMatcher.group(1);
                    String value = attributeMatcher.group(2);
                    this.attributes.put(key.toLowerCase(), value);
                }
            }
            this.attributesCreated = true;
        }
        if (this.attributes == null || this.attributes.isEmpty()) {
            return null;
        }
        return (String)this.attributes.get(name.toLowerCase());
    }

    public String getExtra() {
        if (this.getStatus() != 200) {
            return null;
        }
        if (this.extraCreated) {
            return this.extra;
        }
        this.matcher = PARENTHESIS_PATTERN.matcher(this.firstLine);
        if (this.matcher.find()) {
            this.extra = this.matcher.group(1);
        }
        this.extraCreated = true;
        return this.extra;
    }

    public String getSynopsis() {
        if (this.getStatus() != 520) {
            return null;
        }
        if (!this.synopsisCreated) {
            String line;
            String secondLine;
            Matcher synopsisMatcher;
            if (this.lines.size() > 1 && (synopsisMatcher = SYNOPSIS_PATTERN.matcher(secondLine = (String)this.lines.get(1))).find()) {
                this.synopsis = synopsisMatcher.group(1);
            }
            this.synopsisCreated = true;
            StringBuffer usageSB = new StringBuffer();
            for (int i = 2; i < this.lines.size() && !END_OF_PROPER_USAGE.equals(line = (String)this.lines.get(i)); ++i) {
                usageSB.append(line.trim());
                usageSB.append(" ");
            }
            this.usage = usageSB.toString().trim();
        }
        return this.synopsis;
    }

    public String getUsage() {
        return this.usage;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName() + ": ");
        sb.append("status='" + this.getStatus() + "'; ");
        if (this.status == 200) {
            sb.append("result='" + this.getResult() + "'; ");
            sb.append("extra='" + this.getExtra() + "'; ");
            sb.append("attributes=" + this.attributes + "; ");
        }
        if (this.status == 520) {
            sb.append("synopsis='" + this.getSynopsis() + "'; ");
        }
        sb.append("systemHashcode=" + System.identityHashCode(this));
        return sb.toString();
    }
}

