/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.manager.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.asterisk.io.SocketConnectionFacade;
import net.sf.asterisk.manager.AsteriskServer;
import net.sf.asterisk.manager.Dispatcher;
import net.sf.asterisk.manager.EventBuilder;
import net.sf.asterisk.manager.ManagerReader;
import net.sf.asterisk.manager.ResponseBuilder;
import net.sf.asterisk.manager.event.ConnectEvent;
import net.sf.asterisk.manager.event.DisconnectEvent;
import net.sf.asterisk.manager.event.ManagerEvent;
import net.sf.asterisk.manager.impl.EventBuilderImpl;
import net.sf.asterisk.manager.impl.ResponseBuilderImpl;
import net.sf.asterisk.manager.response.CommandResponse;
import net.sf.asterisk.manager.response.ManagerResponse;
import net.sf.asterisk.util.DateUtil;
import net.sf.asterisk.util.Log;
import net.sf.asterisk.util.LogFactory;

public class ManagerReaderImpl
implements ManagerReader {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final EventBuilder eventBuilder;
    private final ResponseBuilder responseBuilder;
    private final Dispatcher dispatcher;
    private final AsteriskServer asteriskServer;
    private SocketConnectionFacade socket;
    private boolean die = false;

    public ManagerReaderImpl(Dispatcher dispatcher, AsteriskServer asteriskServer) {
        this.dispatcher = dispatcher;
        this.asteriskServer = asteriskServer;
        this.eventBuilder = new EventBuilderImpl();
        this.responseBuilder = new ResponseBuilderImpl();
    }

    public void setSocket(SocketConnectionFacade socket) {
        this.socket = socket;
    }

    public void registerEventClass(Class eventClass) {
        this.eventBuilder.registerEventClass(eventClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        HashMap<String, String> buffer = new HashMap<String, String>();
        ArrayList<String> commandResult = new ArrayList<String>();
        boolean processingCommandResult = false;
        if (this.socket == null) {
            throw new IllegalStateException("Unable to run: socket is null.");
        }
        this.die = false;
        try {
            String line;
            while ((line = this.socket.readLine()) != null && !this.die) {
                if (processingCommandResult) {
                    if ("--END COMMAND--".equals(line) || " --END COMMAND--".equals(line)) {
                        CommandResponse commandResponse = new CommandResponse();
                        for (int crIdx = 0; crIdx < commandResult.size(); ++crIdx) {
                            String[] crNVPair = ((String)commandResult.get(crIdx)).split(" *: *", 2);
                            if (crNVPair[0].equalsIgnoreCase("ActionID")) {
                                commandResult.remove(crIdx--);
                                commandResponse.setActionId(crNVPair[1]);
                                continue;
                            }
                            if (!crNVPair[0].equalsIgnoreCase("Privilege")) break;
                            commandResult.remove(crIdx--);
                        }
                        commandResponse.setResponse("Follows");
                        commandResponse.setDateReceived(DateUtil.getDate());
                        commandResponse.setResult(commandResult);
                        HashMap<String, String> attributes = new HashMap<String, String>();
                        attributes.put("actionid", commandResponse.getActionId());
                        attributes.put("response", commandResponse.getResponse());
                        commandResponse.setAttributes(attributes);
                        this.dispatcher.dispatchResponse(commandResponse);
                        processingCommandResult = false;
                        continue;
                    }
                    commandResult.add(line);
                    continue;
                }
                if ("Response: Follows".equalsIgnoreCase(line)) {
                    processingCommandResult = true;
                    commandResult.clear();
                    continue;
                }
                if (line.startsWith("Asterisk Call Manager/")) {
                    ConnectEvent connectEvent = new ConnectEvent(this.asteriskServer);
                    connectEvent.setProtocolIdentifier(line);
                    connectEvent.setDateReceived(DateUtil.getDate());
                    this.dispatcher.dispatchEvent(connectEvent);
                    continue;
                }
                if (line.length() == 0) {
                    if (buffer.containsKey("response")) {
                        ManagerResponse response = this.buildResponse(buffer);
                        this.logger.debug("attempting to build response");
                        if (response != null) {
                            this.dispatcher.dispatchResponse(response);
                        }
                    } else if (buffer.containsKey("event")) {
                        this.logger.debug("attempting to build event: " + buffer.get("event"));
                        ManagerEvent event = this.buildEvent(this.asteriskServer, buffer);
                        if (event != null) {
                            this.dispatcher.dispatchEvent(event);
                        } else {
                            this.logger.debug("buildEvent returned null");
                        }
                    } else if (buffer.size() > 0) {
                        this.logger.debug("buffer contains neither response nor event");
                    }
                    buffer.clear();
                    continue;
                }
                int delimiterIndex = line.indexOf(":");
                if (delimiterIndex <= 0 || line.length() <= delimiterIndex + 2) continue;
                String name = line.substring(0, delimiterIndex).toLowerCase();
                String value = line.substring(delimiterIndex + 2);
                buffer.put(name, value);
                this.logger.debug("Got name [" + name + "], value: [" + value + "]");
            }
            this.logger.info("Reached end of stream, terminating reader.");
        }
        catch (IOException e) {
            this.logger.info("IOException while reading from asterisk server, terminating reader thread: " + e.getMessage());
        }
        finally {
            DisconnectEvent disconnectEvent = new DisconnectEvent(this.asteriskServer);
            disconnectEvent.setDateReceived(DateUtil.getDate());
            this.dispatcher.dispatchEvent(disconnectEvent);
        }
    }

    public void die() {
        this.die = true;
    }

    private ManagerResponse buildResponse(Map buffer) {
        ManagerResponse response = this.responseBuilder.buildResponse(buffer);
        if (response != null) {
            response.setDateReceived(DateUtil.getDate());
        }
        return response;
    }

    private ManagerEvent buildEvent(Object source, Map buffer) {
        ManagerEvent event = this.eventBuilder.buildEvent(source, buffer);
        if (event != null) {
            event.setDateReceived(DateUtil.getDate());
        }
        return event;
    }
}

